/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.SourceString;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class StringAddAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final boolean noProgress;
    private final String text;
    private final String identifier;
    private final Integer maxLength;
    private final String context;
    private final List<String> files;
    private final List<String> labelNames;
    private final String branchName;
    private final Boolean hidden;
    private final String one;
    private final String two;
    private final String few;
    private final String many;
    private final String zero;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        List<Long> labelIds;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadFullProject);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        boolean isPluralString = this.one != null || this.two != null || this.few != null || this.many != null || this.zero != null;
        List<Long> list = labelIds = this.labelNames != null && !this.labelNames.isEmpty() ? this.prepareLabelIds(client) : null;
        if (isStringsBasedProject) {
            SourceString ss;
            if (this.files != null && !this.files.isEmpty()) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
            }
            Branch branch = BranchUtils.getOrCreateBranch(out, this.branchName, client, project, this.plainView);
            if (Objects.isNull(branch)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project"));
            }
            if (isPluralString) {
                AddSourcePluralStringStringsBasedRequest request = RequestBuilder.addPluralStringStringsBased(this.text, this.identifier, this.maxLength, this.context, branch.getId(), this.hidden, labelIds, this.one, this.two, this.few, this.many, this.zero);
                ss = client.addSourcePluralStringStringsBased(request);
            } else {
                AddSourceStringStringsBasedRequest request = RequestBuilder.addStringStringsBased(this.text, this.identifier, this.maxLength, this.context, branch.getId(), this.hidden, labelIds);
                ss = client.addSourceStringStringsBased(request);
            }
            this.printResult(out, ss);
            return;
        }
        if (this.files == null || this.files.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.file_required"));
        }
        Optional branch = Optional.ofNullable(this.branchName).flatMap(project::findBranchByName);
        if (!branch.isPresent() && this.branchName != null) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch_does_not_exist"), this.branchName));
        }
        List fileInfos = project.getFileInfos().stream().filter(f -> !branch.isPresent() || ((Branch)branch.get()).getId().equals(f.getBranchId())).collect(Collectors.toList());
        Map paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), fileInfos);
        boolean containsError = false;
        for (String file : this.files) {
            SourceString ss;
            if (!paths.containsKey(file)) {
                if (this.files.size() > 1) {
                    containsError = true;
                    out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), file)));
                    continue;
                }
                throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), file));
            }
            Long fileId = ((FileInfo)paths.get(file)).getId();
            if (isPluralString) {
                request = RequestBuilder.addPluralString(this.text, this.identifier, this.maxLength, this.context, fileId, this.hidden, labelIds, this.one, this.two, this.few, this.many, this.zero);
                ss = client.addSourcePluralString((AddSourcePluralStringRequest)request);
            } else {
                request = RequestBuilder.addString(this.text, this.identifier, this.maxLength, this.context, fileId, this.hidden, labelIds);
                ss = client.addSourceString((AddSourceStringRequest)request);
            }
            this.printResult(out, ss);
        }
        if (containsError) {
            throw new RuntimeException();
        }
    }

    private void printResult(Outputter out, SourceString ss) {
        if (!this.plainView) {
            if (ss.getIdentifier() == null) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_text_short"), ss.getId(), this.text)));
            } else {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_text"), ss.getId(), ss.getIdentifier(), this.text)));
            }
        } else {
            out.println(ss.getId().toString());
        }
    }

    private List<Long> prepareLabelIds(ProjectClient client) {
        Map<String, Long> labels = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        this.labelNames.stream().distinct().forEach(labelName -> labels.computeIfAbsent((String)labelName, title -> client.addLabel(RequestBuilder.addLabel(title)).getId()));
        return this.labelNames.stream().map(labels::get).collect(Collectors.toList());
    }

    public StringAddAction(boolean noProgress, String text, String identifier, Integer maxLength, String context, List<String> files, List<String> labelNames, String branchName, Boolean hidden, String one, String two, String few, String many, String zero, boolean plainView) {
        this.noProgress = noProgress;
        this.text = text;
        this.identifier = identifier;
        this.maxLength = maxLength;
        this.context = context;
        this.files = files;
        this.labelNames = labelNames;
        this.branchName = branchName;
        this.hidden = hidden;
        this.one = one;
        this.two = two;
        this.few = few;
        this.many = many;
        this.zero = zero;
        this.plainView = plainView;
    }

    public boolean isNoProgress() {
        return this.noProgress;
    }

    public String getText() {
        return this.text;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getLabelNames() {
        return this.labelNames;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public String getOne() {
        return this.one;
    }

    public String getTwo() {
        return this.two;
    }

    public String getFew() {
        return this.few;
    }

    public String getMany() {
        return this.many;
    }

    public String getZero() {
        return this.zero;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringAddAction)) {
            return false;
        }
        StringAddAction other = (StringAddAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNoProgress() != other.isNoProgress()) {
            return false;
        }
        if (this.isPlainView() != other.isPlainView()) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        List<String> this$files = this.getFiles();
        List<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        List<String> this$labelNames = this.getLabelNames();
        List<String> other$labelNames = other.getLabelNames();
        if (this$labelNames == null ? other$labelNames != null : !((Object)this$labelNames).equals(other$labelNames)) {
            return false;
        }
        String this$branchName = this.getBranchName();
        String other$branchName = other.getBranchName();
        if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) {
            return false;
        }
        String this$one = this.getOne();
        String other$one = other.getOne();
        if (this$one == null ? other$one != null : !this$one.equals(other$one)) {
            return false;
        }
        String this$two = this.getTwo();
        String other$two = other.getTwo();
        if (this$two == null ? other$two != null : !this$two.equals(other$two)) {
            return false;
        }
        String this$few = this.getFew();
        String other$few = other.getFew();
        if (this$few == null ? other$few != null : !this$few.equals(other$few)) {
            return false;
        }
        String this$many = this.getMany();
        String other$many = other.getMany();
        if (this$many == null ? other$many != null : !this$many.equals(other$many)) {
            return false;
        }
        String this$zero = this.getZero();
        String other$zero = other.getZero();
        return !(this$zero == null ? other$zero != null : !this$zero.equals(other$zero));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringAddAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoProgress() ? 79 : 97);
        result = result * 59 + (this.isPlainView() ? 79 : 97);
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        List<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        List<String> $labelNames = this.getLabelNames();
        result = result * 59 + ($labelNames == null ? 43 : ((Object)$labelNames).hashCode());
        String $branchName = this.getBranchName();
        result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
        String $one = this.getOne();
        result = result * 59 + ($one == null ? 43 : $one.hashCode());
        String $two = this.getTwo();
        result = result * 59 + ($two == null ? 43 : $two.hashCode());
        String $few = this.getFew();
        result = result * 59 + ($few == null ? 43 : $few.hashCode());
        String $many = this.getMany();
        result = result * 59 + ($many == null ? 43 : $many.hashCode());
        String $zero = this.getZero();
        result = result * 59 + ($zero == null ? 43 : $zero.hashCode());
        return result;
    }

    public String toString() {
        return "StringAddAction(noProgress=" + this.isNoProgress() + ", text=" + this.getText() + ", identifier=" + this.getIdentifier() + ", maxLength=" + this.getMaxLength() + ", context=" + this.getContext() + ", files=" + String.valueOf(this.getFiles()) + ", labelNames=" + String.valueOf(this.getLabelNames()) + ", branchName=" + this.getBranchName() + ", hidden=" + this.getHidden() + ", one=" + this.getOne() + ", two=" + this.getTwo() + ", few=" + this.getFew() + ", many=" + this.getMany() + ", zero=" + this.getZero() + ", plainView=" + this.isPlainView() + ")";
    }
}

