/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcestrings.model.SourceString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class StringListAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final boolean noProgress;
    private final boolean isVerbose;
    private final String file;
    private final String filter;
    private final String branchName;
    private final List<String> labelNames;
    private final String croql;
    private final String directory;
    private final String scope;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        List<SourceString> sourceStrings;
        String fullPath;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        Long branchId = Optional.ofNullable(project.getBranch()).map(Branch::getId).orElse(null);
        List<Label> labels = client.listLabels();
        Map<Long, String> labelsMap = labels.stream().collect(Collectors.toMap(Label::getId, Label::getTitle));
        Map<String, FileInfo> paths = null;
        Map<Long, String> reversePaths = null;
        if (!isStringsBasedProject) {
            paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFileInfos());
            reversePaths = paths.entrySet().stream().collect(Collectors.toMap(entry -> ((FileInfo)entry.getValue()).getId(), Map.Entry::getKey));
        }
        Map<Long, String> finalReversePaths = reversePaths;
        String encodedFilter = Objects.nonNull(this.filter) ? Utils.encodeURL(this.filter) : null;
        String encodedCroql = Objects.nonNull(this.croql) ? Utils.encodeURL(this.croql) : null;
        String labelIds = Objects.nonNull(this.labelNames) ? this.prepareLabelIds(labels) : null;
        String string = fullPath = Objects.nonNull(this.branchName) ? BranchUtils.normalizeBranchName(this.branchName) + Utils.PATH_SEPARATOR + this.file : this.file;
        if ((!StringUtils.isEmpty(this.file) || Objects.nonNull(this.directory)) && isStringsBasedProject) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
        }
        Long directoryId = null;
        if (!StringUtils.isEmpty(this.directory)) {
            String directoryPath = Utils.toUnixPath(Utils.sepAtStart(this.directory));
            directoryId = project.getDirectories().values().stream().filter(d -> directoryPath.equals(d.getPath())).findFirst().orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.dir_not_exists"), this.directory))).getId();
        }
        if (StringUtils.isEmpty(this.file)) {
            sourceStrings = client.listSourceString(null, branchId, labelIds, encodedFilter, encodedCroql, directoryId, this.scope);
        } else if (paths.containsKey(fullPath)) {
            sourceStrings = client.listSourceString(paths.get(fullPath).getId(), branchId, labelIds, encodedFilter, encodedCroql, directoryId, this.scope);
        } else {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), fullPath));
        }
        if (sourceStrings.isEmpty()) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_not_found")));
        }
        sourceStrings.forEach(ss -> StringListAction.printSourceString(ss, labelsMap, out, isStringsBasedProject, finalReversePaths, this.isVerbose, this.plainView));
    }

    public static void printSourceString(SourceString ss, Map<Long, String> labelsMap, Outputter out, boolean isStringsBasedProject, Map<Long, String> finalReversePaths, boolean isVerbose, boolean plainView) {
        String labelsString = ss.getLabelIds() != null ? ss.getLabelIds().stream().map(labelsMap::get).map(s -> String.format("@|cyan %s|@", s)).collect(Collectors.joining(", ")) : "";
        StringBuilder text = new StringBuilder();
        if (ss.getText() instanceof HashMap) {
            HashMap map = (HashMap)ss.getText();
            for (Map.Entry entry : map.entrySet()) {
                text.append(entry.getKey()).append(": ").append(entry.getValue()).append(" | ");
            }
            if (text.length() > 0) {
                text.delete(text.length() - 3, text.length());
            }
        } else {
            text.append((String)ss.getText());
        }
        if (!plainView) {
            if (ss.getIdentifier() == null) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_text_short"), ss.getId(), text));
            } else {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_text"), ss.getId(), ss.getIdentifier(), text));
            }
        } else {
            out.println(ss.getId().toString());
        }
        if (isVerbose) {
            if (!isStringsBasedProject && ss.getFileId() != null) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_file"), finalReversePaths.get(ss.getFileId())));
            }
            if (!StringUtils.isEmpty(labelsString)) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_labels"), labelsString));
            }
            if (ss.getContext() != null) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.source_string_list_context"), ss.getContext().trim().replaceAll("\n", "\n\t\t")));
            }
        }
    }

    private String prepareLabelIds(List<Label> labels) {
        Map<String, Long> labelsMap = labels.stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        return this.labelNames.stream().map(labelsMap::get).map(String::valueOf).collect(Collectors.joining(","));
    }

    public StringListAction(boolean noProgress, boolean isVerbose, String file, String filter, String branchName, List<String> labelNames, String croql, String directory, String scope, boolean plainView) {
        this.noProgress = noProgress;
        this.isVerbose = isVerbose;
        this.file = file;
        this.filter = filter;
        this.branchName = branchName;
        this.labelNames = labelNames;
        this.croql = croql;
        this.directory = directory;
        this.scope = scope;
        this.plainView = plainView;
    }
}

