/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.EmptyFileException;
import com.crowdin.cli.client.ExistsResponseException;
import com.crowdin.cli.client.FileInUpdateException;
import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.actions.subactions.DeleteObsoleteProjectFilesSubAction;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.ProjectUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.functionality.TranslationsUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.concurrency.ConcurrencyUtil;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.AddFileRequest;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.ExportOptions;
import com.crowdin.client.sourcefiles.model.ExportQuotes;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.GeneralFileExportOptions;
import com.crowdin.client.sourcefiles.model.JavaScriptFileExportOptions;
import com.crowdin.client.sourcefiles.model.OtherFileImportOptions;
import com.crowdin.client.sourcefiles.model.PropertyFileExportOptions;
import com.crowdin.client.sourcefiles.model.SpreadsheetFileImportOptions;
import com.crowdin.client.sourcefiles.model.UpdateFileRequest;
import com.crowdin.client.sourcefiles.model.XmlFileImportOptions;
import com.crowdin.client.sourcestrings.model.ImportOptions;
import com.crowdin.client.sourcestrings.model.UploadStringsProgress;
import com.crowdin.client.sourcestrings.model.UploadStringsRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

class UploadSourcesAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private String branchName;
    private boolean deleteObsolete;
    private boolean noProgress;
    private boolean autoUpdate;
    private boolean debug;
    private boolean plainView;

    public UploadSourcesAction(String branchName, boolean deleteObsolete, boolean noProgress, boolean autoUpdate, boolean debug, boolean plainView) {
        this.branchName = branchName;
        this.deleteObsolete = deleteObsolete;
        this.noProgress = noProgress || plainView;
        this.autoUpdate = autoUpdate;
        this.debug = debug;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, PropertiesWithFiles pb, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadFullProject);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        boolean containsExcludedLanguages = pb.getFiles().stream().map(FileBean::getExcludedTargetLanguages).filter(Objects::nonNull).anyMatch(l -> !l.isEmpty());
        if (!project.isManagerAccess() && (containsExcludedLanguages || this.deleteObsolete)) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access_in_upload_sources")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access_in_upload_sources"));
        }
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(false), pb.getBasePath());
        Branch branch = this.branchName != null ? BranchUtils.getOrCreateBranch(out, this.branchName, client, project, this.plainView) : null;
        Long branchId = branch != null ? branch.getId() : null;
        HashMap<Long, Branch> branchesMap = new HashMap<Long, Branch>(project.getBranches());
        if (branch != null && !branchesMap.containsKey(branchId)) {
            branchesMap.put(branchId, branch);
        }
        Map<String, Long> directoryPaths = null;
        Map<String, FileInfo> paths = null;
        DeleteObsoleteProjectFilesSubAction deleteObsoleteProjectFilesSubAction = new DeleteObsoleteProjectFilesSubAction(out, client);
        if (!isStringsBasedProject) {
            directoryPaths = ProjectFilesUtils.buildDirectoryPaths(project.getDirectories(), branchesMap).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), branchesMap, project.getFileInfos());
            if (this.deleteObsolete) {
                Map<String, Long> directories = ProjectFilesUtils.buildDirectoryPaths(project.getDirectories(branchId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                Map<String, com.crowdin.client.sourcefiles.model.File> projectFiles = ProjectFilesUtils.buildFilePaths(project.getDirectories(branchId), project.getFiles(branchId));
                deleteObsoleteProjectFilesSubAction.setData(projectFiles, directories, pb.getPreserveHierarchy(), this.plainView);
            }
        }
        Map<String, Long> finalDirectoryPaths = directoryPaths;
        Map<String, FileInfo> finalPaths = paths;
        ArrayList uploadedSources = new ArrayList();
        Map<String, Long> labels = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        pb.getFiles().stream().filter(fb -> fb.getLabels() != null).flatMap(fb -> fb.getLabels().stream()).distinct().forEach(labelTitle -> labels.computeIfAbsent((String)labelTitle, title -> client.addLabel(RequestBuilder.addLabel(title)).getId()));
        AtomicBoolean errorsPresented = new AtomicBoolean(false);
        List<Runnable> tasks = pb.getFiles().stream().map(file -> () -> {
            String commonPath;
            try {
                this.checkExcludedTargetLanguages(file.getExcludedTargetLanguages(), project.getSupportedLanguages(), project.getProjectLanguages(false));
            }
            catch (Exception e) {
                errorsPresented.set(true);
                throw e;
            }
            if (isStringsBasedProject && file.getContext() != null && !file.getContext().isEmpty()) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.file_context_for_string_based_project")));
            }
            LanguageMapping localLanguageMapping = LanguageMapping.fromConfigFileLanguageMapping(file.getLanguagesMapping());
            LanguageMapping serverLanguageMapping = project.getLanguageMapping();
            LanguageMapping languageMapping = LanguageMapping.populate(localLanguageMapping, serverLanguageMapping);
            List<String> sources = SourcesUtils.getFiles(pb.getBasePath(), file.getSource(), file.getIgnore(), placeholderUtil, languageMapping).map(File::getAbsolutePath).collect(Collectors.toList());
            String string = commonPath = pb.getPreserveHierarchy() != false ? "" : SourcesUtils.getCommonPath(sources, pb.getBasePath());
            if (this.deleteObsolete) {
                List<String> filesToUpdate = sources.stream().map(source -> file.getDest() != null ? PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(source, pb.getBasePath()), placeholderUtil) : StringUtils.removeStart(source, pb.getBasePath() + commonPath)).collect(Collectors.toList());
                if (file.getDest() != null) {
                    String sourcePattern = PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(file.getSource(), pb.getBasePath()), placeholderUtil);
                    deleteObsoleteProjectFilesSubAction.act(sourcePattern, file.getTranslation(), filesToUpdate);
                } else {
                    deleteObsoleteProjectFilesSubAction.act(file.getSource(), file.getIgnore(), file.getTranslation(), filesToUpdate);
                }
            }
            if (sources.isEmpty()) {
                if (!this.plainView) {
                    errorsPresented.set(true);
                    throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.no_sources"), file.getSource()));
                }
                return;
            }
            Long customSegmentationFileId = null;
            if (file.getCustomSegmentation() != null) {
                File customSegmentation = new File(Utils.normalizePath(Utils.joinPaths(pb.getBasePath(), file.getCustomSegmentation())));
                try (FileInputStream customSegmentationFileStream = new FileInputStream(customSegmentation);){
                    customSegmentationFileId = client.uploadStorage(customSegmentation.getName(), customSegmentationFileStream);
                }
                catch (Exception e) {
                    errorsPresented.set(true);
                    throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), customSegmentation.getAbsolutePath()));
                }
            }
            Long srxStorageId = customSegmentationFileId;
            List<Runnable> taskss = sources.stream().map(source -> {
                Map.Entry projectFile;
                File sourceFile = new File((String)source);
                String filePath = file.getDest() != null ? PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(source, pb.getBasePath()), placeholderUtil) : StringUtils.removeStart(source, pb.getBasePath() + commonPath);
                String fileFullPath = (String)(this.branchName != null ? BranchUtils.normalizeBranchName(this.branchName) + Utils.PATH_SEPARATOR : "") + filePath;
                String fileName = fileFullPath.substring(fileFullPath.lastIndexOf(Utils.PATH_SEPARATOR) + 1);
                List list = uploadedSources;
                synchronized (list) {
                    if (uploadedSources.contains(fileFullPath)) {
                        return this.plainView ? () -> {} : () -> out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.already_uploaded"), fileFullPath)));
                    }
                    uploadedSources.add(fileFullPath);
                }
                Map.Entry entry = projectFile = !isStringsBasedProject ? ProjectFilesUtils.fileLookup(fileFullPath, finalPaths) : null;
                if (!isStringsBasedProject && this.autoUpdate && projectFile != null) {
                    UpdateFileRequest request = new UpdateFileRequest();
                    if (!projectFile.getValue().booleanValue()) {
                        request.setName(source.substring(source.lastIndexOf(Utils.PATH_SEPARATOR) + 1));
                    }
                    request.setExportOptions(this.buildExportOptions(sourceFile, (FileBean)file, pb.getBasePath()));
                    request.setImportOptions(this.buildImportOptions(sourceFile, (FileBean)file, srxStorageId));
                    PropertiesBeanUtils.getUpdateOption(file.getUpdateOption()).ifPresent(request::setUpdateOption);
                    if (file.getLabels() != null) {
                        List<Long> labelsIds = file.getLabels().stream().map(labels::get).collect(Collectors.toList());
                        request.setAttachLabelIds(labelsIds);
                    }
                    Long sourceId = ((FileInfo)projectFile.getKey()).getId();
                    return () -> {
                        try (FileInputStream fileStream = new FileInputStream(sourceFile);){
                            request.setStorageId(client.uploadStorage(source.substring(source.lastIndexOf(Utils.PATH_SEPARATOR) + 1), fileStream));
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), sourceFile.getAbsolutePath()));
                        }
                        try {
                            client.updateSource(sourceId, request);
                            if (file.getExcludedTargetLanguages() != null && !file.getExcludedTargetLanguages().isEmpty()) {
                                List<String> projectFileExcludedTargetLanguages = ((com.crowdin.client.sourcefiles.model.File)projectFile.getKey()).getExcludedTargetLanguages();
                                if (!file.getExcludedTargetLanguages().equals(projectFileExcludedTargetLanguages)) {
                                    List<PatchRequest> editRequest = RequestBuilder.updateExcludedTargetLanguages(file.getExcludedTargetLanguages());
                                    client.editSource(sourceId, editRequest);
                                }
                            }
                            if (!this.plainView) {
                                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
                            } else {
                                out.println(fileFullPath);
                            }
                        }
                        catch (FileInUpdateException e) {
                            if (!this.plainView) {
                                out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file_being_updated"), fileFullPath)));
                            } else {
                                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.file_being_updated"));
                            }
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.uploading_file"), fileFullPath));
                        }
                    };
                }
                if (projectFile == null && !isStringsBasedProject) {
                    AddFileRequest request = new AddFileRequest();
                    request.setName(fileName);
                    request.setExportOptions(this.buildExportOptions(sourceFile, (FileBean)file, pb.getBasePath()));
                    request.setImportOptions(this.buildImportOptions(sourceFile, (FileBean)file, srxStorageId));
                    if (file.getExcludedTargetLanguages() != null && !file.getExcludedTargetLanguages().isEmpty()) {
                        request.setExcludedTargetLanguages(file.getExcludedTargetLanguages());
                    }
                    if (file.getType() != null) {
                        request.setType(file.getType());
                    }
                    if (file.getLabels() != null) {
                        List<Long> labelsIds = file.getLabels().stream().map(labels::get).collect(Collectors.toList());
                        request.setAttachLabelIds(labelsIds);
                    }
                    if (file.getContext() != null && !file.getContext().isEmpty()) {
                        String contextPath = placeholderUtil.replaceFileDependentPlaceholders(file.getContext(), sourceFile);
                        try {
                            String context = Files.readString(Paths.get(pb.getBasePath(), contextPath));
                            request.setContext(context);
                        }
                        catch (IOException e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.reading_context_file"));
                        }
                    }
                    return () -> {
                        Long directoryId;
                        try {
                            directoryId = ProjectUtils.createPath(out, client, finalDirectoryPaths, filePath, branch, this.plainView);
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.creating_directories"));
                        }
                        if (directoryId != null) {
                            request.setDirectoryId(directoryId);
                        } else if (branch != null) {
                            request.setBranchId(branch.getId());
                        }
                        try (FileInputStream fileStream = new FileInputStream(sourceFile);){
                            request.setStorageId(client.uploadStorage(source.substring(source.lastIndexOf(Utils.PATH_SEPARATOR) + 1), fileStream));
                        }
                        catch (EmptyFileException e) {
                            errorsPresented.set(false);
                            out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file_skipped"), fileFullPath)));
                            return;
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), sourceFile.getAbsolutePath()));
                        }
                        try {
                            client.addSource(request);
                        }
                        catch (ExistsResponseException e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_already_exists"), fileFullPath));
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.uploading_file"), fileFullPath));
                        }
                        if (!this.plainView) {
                            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
                        } else {
                            out.println(fileFullPath);
                        }
                    };
                }
                if (isStringsBasedProject) {
                    UploadStringsRequest request = new UploadStringsRequest();
                    request.setImportOptions(this.buildImportOptionsStringsBased(sourceFile, (FileBean)file, srxStorageId));
                    if (file.getType() != null) {
                        request.setType(file.getType());
                    }
                    if (file.getLabels() != null) {
                        List<Long> labelsIds = file.getLabels().stream().map(labels::get).collect(Collectors.toList());
                        request.setLabelIds(labelsIds);
                    }
                    return () -> {
                        if (branch == null) {
                            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project"));
                        }
                        request.setBranchId(branch.getId());
                        try (FileInputStream fileStream = new FileInputStream(sourceFile);){
                            request.setStorageId(client.uploadStorage(source.substring(source.lastIndexOf(Utils.PATH_SEPARATOR) + 1), fileStream));
                        }
                        catch (EmptyFileException e) {
                            errorsPresented.set(false);
                            out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file_skipped"), fileFullPath)));
                            return;
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), sourceFile.getAbsolutePath()));
                        }
                        try {
                            ConsoleSpinner.execute(out, "message.spinner.uploading_strings", "message.spinner.upload_strings_failed", this.plainView, this.plainView, () -> {
                                UploadStringsProgress uploadStrings = client.addSourceStringsBased(request);
                                String uploadId = uploadStrings.getIdentifier();
                                while (!"finished".equalsIgnoreCase(uploadStrings.getStatus())) {
                                    ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.uploading_strings_percents"), uploadStrings.getProgress()));
                                    Thread.sleep(1000L);
                                    uploadStrings = client.getUploadStringsStatus(uploadId);
                                    if (!"failed".equalsIgnoreCase(uploadStrings.getStatus())) continue;
                                    throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.upload_strings_failed"));
                                }
                                ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.uploading_strings_percents"), 100));
                                return uploadStrings;
                            });
                        }
                        catch (Exception e) {
                            errorsPresented.set(true);
                            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.uploading_file"), fileFullPath));
                        }
                        if (!this.plainView) {
                            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
                        } else {
                            out.println(fileFullPath);
                        }
                    };
                }
                return () -> {
                    if (!this.plainView) {
                        out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
                    }
                };
            }).collect(Collectors.toList());
            if (isStringsBasedProject) {
                ConcurrencyUtil.executeAndWaitSingleThread(taskss, this.debug);
            } else {
                ConcurrencyUtil.executeAndWait(taskss, this.debug);
            }
        }).collect(Collectors.toList());
        ConcurrencyUtil.executeAndWaitSingleThread(tasks, this.debug);
        if (this.deleteObsolete) {
            deleteObsoleteProjectFilesSubAction.postAct();
        }
        if (errorsPresented.get()) {
            throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.execution_contains_errors"));
        }
    }

    private com.crowdin.client.sourcefiles.model.ImportOptions buildImportOptions(File sourceFile, FileBean fileBean, Long srxStorageId) {
        if (this.isSpreadsheet(sourceFile, fileBean)) {
            SpreadsheetFileImportOptions importOptions = new SpreadsheetFileImportOptions();
            importOptions.setFirstLineContainsHeader(fileBean.getFirstLineContainsHeader());
            importOptions.setScheme(PropertiesBeanUtils.getSchemeObject(fileBean.getScheme()));
            importOptions.setImportTranslations(fileBean.getImportTranslations());
            return importOptions;
        }
        if (this.isXml(sourceFile)) {
            XmlFileImportOptions importOptions = new XmlFileImportOptions();
            importOptions.setTranslateContent(fileBean.getTranslateContent());
            importOptions.setTranslateAttributes(fileBean.getTranslateAttributes());
            importOptions.setContentSegmentation(fileBean.getContentSegmentation());
            importOptions.setTranslatableElements(fileBean.getTranslatableElements());
            importOptions.setSrxStorageId(srxStorageId);
            return importOptions;
        }
        OtherFileImportOptions importOptions = new OtherFileImportOptions();
        importOptions.setContentSegmentation(fileBean.getContentSegmentation());
        importOptions.setSrxStorageId(srxStorageId);
        return importOptions;
    }

    private ImportOptions buildImportOptionsStringsBased(File sourceFile, FileBean fileBean, Long srxStorageId) {
        ImportOptions importOptions = new ImportOptions();
        if (this.isSpreadsheet(sourceFile, fileBean)) {
            importOptions.setFirstLineContainsHeader(fileBean.getFirstLineContainsHeader());
            importOptions.setScheme(PropertiesBeanUtils.getSchemeObject(fileBean.getScheme()));
            importOptions.setImportTranslations(fileBean.getImportTranslations());
        }
        return importOptions;
    }

    private boolean isSpreadsheet(File file, FileBean fileBean) {
        return fileBean.getDest() != null ? FilenameUtils.isExtension(fileBean.getDest(), "csv", "xls", "xlsx") : FilenameUtils.isExtension(file.getName(), "csv", "xls", "xlsx");
    }

    private boolean isXml(File file) {
        return FilenameUtils.isExtension(file.getName(), "xml");
    }

    private ExportOptions buildExportOptions(File sourceFile, FileBean fileBean, String basePath) {
        String exportPattern = TranslationsUtils.replaceDoubleAsterisk(fileBean.getSource(), fileBean.getTranslation(), StringUtils.removeStart(sourceFile.getAbsolutePath(), basePath));
        exportPattern = StringUtils.replacePattern(exportPattern, "[\\\\/]+", "/");
        if (SourcesUtils.isFileProperties(sourceFile)) {
            PropertyFileExportOptions exportOptions = new PropertyFileExportOptions();
            exportOptions.setExportPattern(exportPattern);
            exportOptions.setEscapeQuotes(fileBean.getEscapeQuotes());
            exportOptions.setEscapeSpecialCharacters(1);
            if (fileBean.getEscapeSpecialCharacters() != null) {
                exportOptions.setEscapeSpecialCharacters(fileBean.getEscapeSpecialCharacters());
            }
            return exportOptions;
        }
        if (SourcesUtils.isFileJavaScript(sourceFile)) {
            JavaScriptFileExportOptions exportOptions = new JavaScriptFileExportOptions();
            exportOptions.setExportPattern(exportPattern);
            if (fileBean.getExportQuotes() != null) {
                exportOptions.setExportQuotes(fileBean.getExportQuotes().equals("double") ? ExportQuotes.DOUBLE : ExportQuotes.SINGLE);
            }
            return exportOptions;
        }
        GeneralFileExportOptions exportOptions = new GeneralFileExportOptions();
        exportOptions.setExportPattern(exportPattern);
        return exportOptions;
    }

    private void checkExcludedTargetLanguages(List<String> excludedTargetLanguages, List<Language> supportedLanguages, List<Language> projectLanguages) {
        if (excludedTargetLanguages != null && !excludedTargetLanguages.isEmpty()) {
            List supportedLanguageIds = supportedLanguages.stream().map(Language::getId).collect(Collectors.toList());
            List projectLanguageIds = projectLanguages.stream().map(Language::getId).collect(Collectors.toList());
            String notSupportedLangs = excludedTargetLanguages.stream().filter(lang -> !supportedLanguageIds.contains(lang)).map(lang -> "'" + lang + "'").collect(Collectors.joining(", "));
            if (notSupportedLangs.length() > 0) {
                throw new ExitCodeExceptionMapper.ValidationException(String.format("Crowdin doesn't support %s language code(s)", notSupportedLangs));
            }
            String notInProjectLangs = excludedTargetLanguages.stream().filter(lang -> !projectLanguageIds.contains(lang)).map(lang -> "'" + lang + "'").collect(Collectors.joining(", "));
            if (notInProjectLangs.length() > 0) {
                throw new ExitCodeExceptionMapper.NotFoundException(String.format("Project doesn't have %s language(s)", notInProjectLangs));
            }
        }
    }
}

