/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions.subactions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.ObsoleteSourcesUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.sourcefiles.model.File;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import lombok.NonNull;

public class DeleteObsoleteProjectFilesSubAction {
    private final Outputter out;
    private final ProjectClient client;
    private Map<String, File> projectFiles;
    private Map<String, Long> directoryIds;
    private Boolean preserveHierarchy;
    private boolean plainView;
    private boolean isAnyFileDeleted = false;
    private boolean isAnyDirectoryDeleted = false;

    public DeleteObsoleteProjectFilesSubAction(@NonNull Outputter out, @NonNull ProjectClient client) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.out = out;
        this.client = client;
    }

    public void setData(@NonNull Map<String, File> projectFiles, @NonNull Map<String, Long> directoryIds, @NonNull Boolean preserveHierarchy, boolean plainView) {
        if (projectFiles == null) {
            throw new NullPointerException("projectFiles is marked non-null but is null");
        }
        if (directoryIds == null) {
            throw new NullPointerException("directoryIds is marked non-null but is null");
        }
        if (preserveHierarchy == null) {
            throw new NullPointerException("preserveHierarchy is marked non-null but is null");
        }
        this.projectFiles = projectFiles;
        this.directoryIds = directoryIds;
        this.preserveHierarchy = preserveHierarchy;
        this.plainView = plainView;
    }

    public void act(@NonNull String destPattern, @NonNull String ignorePatterns, @NonNull List<String> filesToUpload) {
        if (destPattern == null) {
            throw new NullPointerException("destPattern is marked non-null but is null");
        }
        if (ignorePatterns == null) {
            throw new NullPointerException("ignorePatterns is marked non-null but is null");
        }
        if (filesToUpload == null) {
            throw new NullPointerException("filesToUpload is marked non-null but is null");
        }
        this.act(destPattern, null, ignorePatterns, filesToUpload);
    }

    public void act(@NonNull String sourcePattern, List<String> ignorePatterns, @NonNull String exportPattern, @NonNull List<String> filesToUpload) {
        if (sourcePattern == null) {
            throw new NullPointerException("sourcePattern is marked non-null but is null");
        }
        if (exportPattern == null) {
            throw new NullPointerException("exportPattern is marked non-null but is null");
        }
        if (filesToUpload == null) {
            throw new NullPointerException("filesToUpload is marked non-null but is null");
        }
        filesToUpload = filesToUpload.stream().map(Utils::noSepAtStart).collect(Collectors.toList());
        if (this.projectFiles == null || this.directoryIds == null || this.preserveHierarchy == null) {
            throw new ExitCodeExceptionMapper.ValidationException("Unexpected error: DeleteObsoleteProjectFilesSubAction is not properly set");
        }
        Map<String, File> obsoleteProjectFiles = ObsoleteSourcesUtils.findObsoleteProjectFiles(this.projectFiles, this.preserveHierarchy, filesToUpload, sourcePattern, exportPattern, ignorePatterns);
        SortedMap<String, Long> obsoleteDirs = ObsoleteSourcesUtils.findObsoleteProjectDirectories(this.projectFiles, this.directoryIds, filesToUpload, obsoleteProjectFiles);
        for (String obsoleteProjectFilePath : obsoleteProjectFiles.keySet()) {
            this.client.deleteSource(obsoleteProjectFiles.get(obsoleteProjectFilePath).getId());
            this.projectFiles.remove(obsoleteProjectFilePath);
            if (!this.plainView) {
                this.out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.delete_obsolete.obsolete_file_delete"), obsoleteProjectFilePath)));
            }
            this.isAnyFileDeleted = true;
        }
        for (String obsoleteDirPath : obsoleteDirs.keySet()) {
            this.client.deleteDirectory((Long)obsoleteDirs.get(obsoleteDirPath));
            this.directoryIds.remove(obsoleteDirPath);
            if (!this.plainView) {
                this.out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.delete_obsolete.no_obsolete_files_found"), obsoleteDirPath)));
            }
            this.isAnyDirectoryDeleted = true;
        }
    }

    public void postAct() {
        if (!this.isAnyFileDeleted && !this.plainView) {
            this.out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.delete_obsolete.obsolete_directory_delete")));
        }
        if (!this.isAnyDirectoryDeleted && !this.plainView) {
            this.out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.delete_obsolete.no_obsolete_directories_found")));
        }
    }
}

