/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.cli.utils.tree.DrawTree;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Dryrun {
    private String messageKey;

    protected abstract List<String> getFiles();

    protected Dryrun() {
        this("message.file_path");
    }

    protected Dryrun(String messageKey) {
        this.messageKey = messageKey;
    }

    public void run(Outputter out, boolean treeView) {
        this.run(out, treeView, false);
    }

    public void run(Outputter out, boolean treeView, boolean plainView) {
        List<String> files = this.getFiles().stream().map(f -> f.replaceAll("^[/\\\\]+", "")).sorted().collect(Collectors.toList());
        if (treeView) {
            DrawTree.draw(files).forEach(out::println);
        } else if (!plainView) {
            files.forEach(file -> out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString(this.messageKey), file))));
        } else {
            files.forEach(out::println);
        }
    }
}

