/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.functionality.FilesInterface;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.io.FileUtils;

public class FsFiles
implements FilesInterface {
    @Override
    public void writeToFile(String file, InputStream data) throws IOException {
        com.crowdin.cli.utils.file.FileUtils.writeToFile(data, file);
    }

    @Override
    public void copyFile(File fromFile, File toFile) {
        try {
            if (toFile.toPath().getParent() != null) {
                Files.createDirectories(toFile.toPath().getParent(), new FileAttribute[0]);
            }
            Files.copy(fromFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.replacing_file"), toFile.getAbsolutePath()), e);
        }
    }

    @Override
    public List<File> extractZipArchive(File zipArchive, File dir) {
        ZipFile zipFile;
        ArrayList<File> extractedFiles = new ArrayList<File>();
        try {
            zipFile = new ZipFile(zipArchive);
        }
        catch (IllegalArgumentException e) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.archive_not_exist"), zipArchive.getAbsolutePath()));
        }
        if (!dir.exists()) {
            try {
                Files.createDirectory(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.creatingDirectory"));
            }
        }
        Integer filesQnt = null;
        try {
            List<FileHeader> fileHeaders = zipFile.getFileHeaders();
            filesQnt = fileHeaders.size();
            for (FileHeader fileHeader : fileHeaders) {
                if (!fileHeader.isDirectory()) {
                    File destFile = new File(dir, fileHeader.getFileName());
                    destFile.getParentFile().mkdirs();
                    zipFile.extractFile(fileHeader, dir.getAbsolutePath());
                    extractedFiles.add(destFile);
                    continue;
                }
                new File(dir.getAbsolutePath() + File.separator + fileHeader.getFileName()).mkdirs();
            }
        }
        catch (ZipException e) {
            if (filesQnt != null && filesQnt.equals(1)) {
                return new ArrayList<File>();
            }
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.extract_archive"), zipArchive.getAbsolutePath()));
        }
        return extractedFiles;
    }

    @Override
    public List<String> zipArchiveContent(File zipArchive) {
        ZipFile zipFile;
        ArrayList<String> archiveFiles = new ArrayList<String>();
        try {
            zipFile = new ZipFile(zipArchive);
        }
        catch (IllegalArgumentException e) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.archive_not_exist"), zipArchive.getAbsolutePath()));
        }
        try {
            List<FileHeader> fileHeaders = zipFile.getFileHeaders();
            for (FileHeader fileHeader : fileHeaders) {
                archiveFiles.add(fileHeader.getFileName());
            }
        }
        catch (ZipException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.extract_archive"), zipArchive.getAbsolutePath()));
        }
        return archiveFiles;
    }

    @Override
    public void deleteFile(File file) throws IOException {
        Files.delete(file.toPath());
    }

    @Override
    public void deleteDirectory(File dir) throws IOException {
        FileUtils.deleteDirectory(dir);
    }
}

