/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.Directory;
import com.crowdin.client.sourcefiles.model.ExportOptions;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.GeneralFileExportOptions;
import com.crowdin.client.sourcefiles.model.PropertyFileExportOptions;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class ProjectFilesUtils {
    public static <T extends FileInfo> Map<String, T> buildFilePaths(Map<Long, Directory> directories, Map<Long, Branch> branchNames, List<T> files) {
        Map<Long, String> directoryPaths = ProjectFilesUtils.buildDirectoryPaths(directories, branchNames);
        HashMap filePathsToId = new HashMap();
        files.forEach(fe -> filePathsToId.put(ProjectFilesUtils.getParentId(fe).map(directoryPaths::get).orElse("") + fe.getName(), fe));
        return filePathsToId;
    }

    public static <T> Map.Entry<T, Boolean> fileLookup(String filePath, Map<String, T> files) {
        if (files.containsKey(filePath)) {
            return new AbstractMap.SimpleEntry<T, Boolean>(files.get(filePath), true);
        }
        Object fallback = null;
        for (Map.Entry<String, T> entry : files.entrySet()) {
            if (ProjectFilesUtils.equalsIgnoreExtension(filePath, entry.getKey())) {
                return new AbstractMap.SimpleEntry<T, Boolean>(entry.getValue(), false);
            }
            if (!ProjectFilesUtils.equalsIgnoreExtraExtension(filePath, entry.getKey())) continue;
            fallback = entry.getValue();
        }
        if (fallback == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<Object, Boolean>(fallback, false);
    }

    public static boolean equalsIgnoreExtension(String file1, String file2) {
        return ProjectFilesUtils.removeExtension(file1).equals(ProjectFilesUtils.removeExtension(file2));
    }

    public static boolean equalsIgnoreExtraExtension(String file1, String file2) {
        return file1.equals(ProjectFilesUtils.removeExtension(file2)) || ProjectFilesUtils.removeExtension(file1).equals(file2);
    }

    public static String removeExtension(String file) {
        if (!file.contains(".")) {
            return file;
        }
        return file.substring(0, file.lastIndexOf(46));
    }

    public static <T extends FileInfo> Map<String, T> buildFilePaths(Map<Long, Directory> directories, List<T> files) {
        Map<Long, String> directoryPaths = ProjectFilesUtils.buildDirectoryPaths(directories);
        HashMap filePathsToId = new HashMap();
        files.forEach(fe -> filePathsToId.put(Optional.ofNullable(fe.getDirectoryId()).map(directoryPaths::get).orElse("") + fe.getName(), fe));
        return filePathsToId;
    }

    public static Map<Long, String> buildDirectoryPaths(Map<Long, Directory> directories, Map<Long, Branch> branches) {
        HashMap<Long, String> directoryPaths = new HashMap<Long, String>();
        directories.forEach((dirId, dir) -> directoryPaths.put((Long)dirId, ProjectFilesUtils.buildBranchPath(dir.getBranchId(), branches) + ProjectFilesUtils.buildDirectoryPath(dir.getId(), directories)));
        branches.keySet().forEach(brId -> directoryPaths.put((Long)brId, ProjectFilesUtils.buildBranchPath(brId, branches)));
        return directoryPaths;
    }

    public static Map<Long, String> buildDirectoryPaths(Map<Long, Directory> directories) {
        HashMap<Long, String> directoryPaths = new HashMap<Long, String>();
        directories.forEach((dirId, dir) -> directoryPaths.put((Long)dirId, ProjectFilesUtils.buildDirectoryPath(dir.getId(), directories)));
        return directoryPaths;
    }

    public static Map<String, List<String>> buildAllProjectTranslations(List<com.crowdin.client.sourcefiles.model.File> projectFiles, Map<Long, String> directoryPaths, Optional<Long> branchId, PlaceholderUtil placeholderUtil, LanguageMapping languageMapping, String basePath) {
        HashMap<String, List<String>> allProjectTranslations = new HashMap<String, List<String>>();
        for (com.crowdin.client.sourcefiles.model.File fe : projectFiles) {
            Stream<String> translations;
            if (branchId.isPresent() && !branchId.get().equals(fe.getBranchId())) continue;
            String path = ProjectFilesUtils.getParentId(fe).map(directoryPaths::get).orElse("") + fe.getName();
            if (ProjectFilesUtils.isMultilingualFile(fe)) {
                translations = Stream.concat(Stream.of(Utils.normalizePath(fe.getName())), placeholderUtil.replaceLanguageDependentPlaceholders(Utils.joinPaths("%language_id%", fe.getName()), languageMapping).stream());
            } else {
                String exportPattern = Utils.normalizePath(ProjectFilesUtils.getExportPattern(fe.getExportOptions()));
                if (!PlaceholderUtil.containsLangPlaceholders(exportPattern)) {
                    exportPattern = Utils.joinPaths("%language_id%", exportPattern);
                }
                String fileDependentPlaceholdersReplaced = placeholderUtil.replaceFileDependentPlaceholders(exportPattern, new File(basePath + path));
                translations = placeholderUtil.replaceLanguageDependentPlaceholders(fileDependentPlaceholdersReplaced, languageMapping).stream().map(translation -> (fe.getBranchId() != null ? directoryPaths.getOrDefault(fe.getBranchId(), "") : "") + translation);
            }
            allProjectTranslations.put(path, translations.collect(Collectors.toList()));
        }
        return allProjectTranslations;
    }

    private static String buildDirectoryPath(Long directoryId, Map<Long, Directory> directories) {
        StringBuilder sb = new StringBuilder();
        if (directoryId != null) {
            Directory dir = directories.get(directoryId);
            while (dir != null) {
                sb.insert(0, dir.getName() + Utils.PATH_SEPARATOR);
                dir = directories.get(dir.getDirectoryId());
            }
        }
        return sb.toString();
    }

    public static String buildBranchPath(Long branchId, Map<Long, Branch> branchNames) {
        return branchId != null ? branchNames.get(branchId).getName() + Utils.PATH_SEPARATOR : "";
    }

    private static Optional<Long> getParentId(FileInfo fe) {
        return fe.getDirectoryId() != null ? Optional.of(fe.getDirectoryId()) : Optional.ofNullable(fe.getBranchId());
    }

    public static boolean isMultilingualFile(com.crowdin.client.sourcefiles.model.File fe) {
        return ProjectFilesUtils.getExportPattern(fe.getExportOptions()) == null;
    }

    public static String getExportPattern(ExportOptions exportOptions) {
        if (exportOptions instanceof PropertyFileExportOptions) {
            return ((PropertyFileExportOptions)exportOptions).getExportPattern();
        }
        if (exportOptions instanceof GeneralFileExportOptions) {
            return ((GeneralFileExportOptions)exportOptions).getExportPattern();
        }
        return null;
    }

    public static Predicate<String> isProjectFilePathSatisfiesPatterns(@NonNull String sourcePattern, List<String> ignorePatterns, boolean preserveHierarchy) {
        Predicate<String> sourcePatternPred;
        if (sourcePattern == null) {
            throw new NullPointerException("sourcePattern is marked non-null but is null");
        }
        if (preserveHierarchy) {
            sourcePatternPred = Pattern.compile("^" + PlaceholderUtil.formatSourcePatternForRegex(Utils.noSepAtStart(sourcePattern)) + "$").asPredicate();
        } else {
            List sourcePatternSplits = Arrays.stream(Utils.splitPath(Utils.noSepAtStart(sourcePattern))).map(PlaceholderUtil::formatSourcePatternForRegex).collect(Collectors.toList());
            StringBuilder sourcePatternRegex = new StringBuilder();
            for (int i = 0; i < sourcePatternSplits.size() - 1; ++i) {
                sourcePatternRegex.insert(0, "(").append((String)sourcePatternSplits.get(i)).append(Utils.PATH_SEPARATOR_REGEX).append(")?");
            }
            sourcePatternRegex.insert(0, "^").append((String)sourcePatternSplits.get(sourcePatternSplits.size() - 1)).append("$");
            sourcePatternPred = Pattern.compile(sourcePatternRegex.toString()).asPredicate();
        }
        Predicate ignorePatternPred = ignorePatterns != null && !ignorePatterns.isEmpty() ? (preserveHierarchy ? ignorePatterns.stream().map(Utils::noSepAtStart).map(ignorePattern -> "^" + PlaceholderUtil.formatSourcePatternForRegex(ignorePattern) + "$").map(Pattern::compile).map(Pattern::asPredicate).reduce(s -> false, Predicate::or) : ignorePatterns.stream().map(Utils::noSepAtStart).map(ignorePattern -> {
            List ignorePatternSplits = Arrays.stream(Utils.splitPath(ignorePattern)).map(PlaceholderUtil::formatSourcePatternForRegex).collect(Collectors.toList());
            StringBuilder ignorePatternRegex = new StringBuilder();
            for (int i = 0; i < ignorePatternSplits.size() - 1; ++i) {
                ignorePatternRegex.insert(0, "(").append((String)ignorePatternSplits.get(i)).append(Utils.PATH_SEPARATOR_REGEX).append(")?");
            }
            ignorePatternRegex.insert(0, "^").append((String)ignorePatternSplits.get(ignorePatternSplits.size() - 1)).append("$");
            return ignorePatternRegex.toString();
        }).map(Pattern::compile).map(Pattern::asPredicate).reduce(s -> false, Predicate::or)) : projectFilePath -> false;
        return projectFilePath -> !ignorePatternPred.test(projectFilePath) && sourcePatternPred.test((String)projectFilePath);
    }
}

