/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.utils.Utils;
import org.apache.commons.lang3.StringUtils;

public class TranslationsUtils {
    public static String replaceDoubleAsterisk(String sourcePattern, String translationPattern, String sourceFile) {
        if (StringUtils.isAnyEmpty(translationPattern, sourceFile)) {
            throw new ExitCodeExceptionMapper.ValidationException("No sources and/or translations");
        }
        if (!translationPattern.contains("**")) {
            return translationPattern;
        }
        if (!sourcePattern.contains("**")) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.config.double_asterisk"));
        }
        sourcePattern = StringUtils.removeStart(sourcePattern, Utils.PATH_SEPARATOR);
        String[] sourceNodes = sourcePattern.split("\\*\\*");
        for (int i = 0; i < sourceNodes.length; ++i) {
            if (sourceFile.contains(sourceNodes[i])) {
                sourceFile = StringUtils.substring(sourceFile, sourceFile.indexOf(sourceNodes[i]), sourceFile.length() - 1).replaceFirst(Utils.regexPath(sourceNodes[i]), "");
                continue;
            }
            if (sourceNodes.length - 1 != i) continue;
            if (sourceNodes[i].contains(Utils.PATH_SEPARATOR)) {
                String[] sourceNodesTmp;
                for (String sourceNode : sourceNodesTmp = sourceNodes[i].split(Utils.PATH_SEPARATOR_REGEX)) {
                    String s = Utils.PATH_SEPARATOR + sourceNode + Utils.PATH_SEPARATOR;
                    if (sourceFile.contains(s)) {
                        sourceFile = sourceFile.replaceFirst(Utils.regexPath(s), Utils.regexPath(Utils.PATH_SEPARATOR));
                        continue;
                    }
                    if (StringUtils.indexOfAny((CharSequence)s, "*", "?", "[", "]", ".") >= 0) {
                        if (sourceFile.lastIndexOf(Utils.PATH_SEPARATOR) > 0) {
                            sourceFile = sourceFile.substring(0, sourceFile.lastIndexOf(Utils.PATH_SEPARATOR));
                            continue;
                        }
                        sourceFile = "";
                        continue;
                    }
                    if (Utils.noSepAtStart(s).length() <= 0 || !sourceFile.startsWith(Utils.noSepAtStart(s))) continue;
                    sourceFile = "";
                }
                continue;
            }
            if (!sourceFile.contains(".")) continue;
            sourceFile = "";
        }
        translationPattern = translationPattern.replace("**", sourceFile);
        translationPattern = translationPattern.replaceAll(Utils.PATH_SEPARATOR_REGEX + "+", Utils.PATH_SEPARATOR_REGEX);
        return translationPattern;
    }
}

