/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandBundle;
import com.crowdin.cli.properties.ProjectProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import picocli.CommandLine;

@CommandLine.Command(name="add", sortOptions=false)
class BundleAddSubcommand
extends ActCommandBundle {
    @CommandLine.Parameters(descriptionKey="crowdin.bundle.add.name")
    protected String name;
    @CommandLine.Option(names={"--format"}, paramLabel="...", descriptionKey="crowdin.bundle.add.format", order=-2)
    protected String format;
    @CommandLine.Option(names={"--source"}, paramLabel="...", descriptionKey="crowdin.bundle.add.source", order=-2)
    protected List<String> source;
    @CommandLine.Option(names={"--ignore"}, paramLabel="...", descriptionKey="crowdin.bundle.add.ignore", order=-2)
    protected List<String> ignore;
    @CommandLine.Option(names={"--translation"}, paramLabel="...", descriptionKey="crowdin.bundle.add.translation", order=-2)
    protected String translation;
    @CommandLine.Option(names={"--label"}, paramLabel="...", descriptionKey="crowdin.bundle.add.label", order=-2)
    protected List<Long> labels;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;
    @CommandLine.Option(names={"--include-source-language"}, paramLabel="...", descriptionKey="crowdin.bundle.add.includeProjectSourceLanguage", order=-2)
    protected boolean includeProjectSourceLanguage;
    @CommandLine.Option(names={"--include-pseudo-language"}, paramLabel="...", descriptionKey="crowdin.bundle.add.includePseudoLanguage", order=-2)
    protected boolean includePseudoLanguage = true;
    @CommandLine.Option(names={"--multilingual"}, paramLabel="...", descriptionKey="crowdin.bundle.add.isMultilingual", order=-2)
    protected boolean isMultilingual;

    BundleAddSubcommand() {
    }

    @Override
    protected final boolean isAnsi() {
        return super.isAnsi() && !this.plainView;
    }

    @Override
    protected NewAction<ProjectProperties, ClientBundle> getAction(Actions actions) {
        return actions.bundleAdd(this.name, this.format, this.source, this.ignore, this.translation, this.labels, this.plainView, this.includeProjectSourceLanguage, this.includePseudoLanguage, this.isMultilingual);
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (Strings.isEmpty(this.name)) {
            errors.add(RESOURCE_BUNDLE.getString("error.bundle.empty_name"));
        }
        if (Strings.isEmpty(this.format)) {
            errors.add(RESOURCE_BUNDLE.getString("error.bundle.empty_format"));
        }
        if (this.source == null || this.source.isEmpty()) {
            errors.add(RESOURCE_BUNDLE.getString("error.bundle.empty_source"));
        }
        if (Strings.isEmpty(this.translation)) {
            errors.add(RESOURCE_BUNDLE.getString("error.bundle.empty_translation"));
        }
        return errors;
    }
}

