/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandProject;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.client.stringcomments.model.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import picocli.CommandLine;

@CommandLine.Command(sortOptions=false, name="add")
class CommentAddSubcommand
extends ActCommandProject {
    @CommandLine.Parameters(descriptionKey="crowdin.comment.add.text")
    protected String text;
    @CommandLine.Option(names={"--string-id"}, paramLabel="...", descriptionKey="crowdin.comment.add.string-id", order=-2)
    protected String stringId;
    @CommandLine.Option(names={"-l", "--language"}, paramLabel="...", descriptionKey="crowdin.comment.add.language", order=-2)
    protected String languageId;
    @CommandLine.Option(names={"--type"}, paramLabel="...", descriptionKey="crowdin.comment.add.type", order=-2)
    protected String type;
    @CommandLine.Option(names={"--issue-type"}, paramLabel="...", descriptionKey="crowdin.comment.add.issue-type", order=-2)
    protected String issueType;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    CommentAddSubcommand() {
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        this.type = Objects.toString(this.type, Type.COMMENT.toString().toLowerCase());
        if (Strings.isEmpty(this.stringId)) {
            errors.add(RESOURCE_BUNDLE.getString("error.comment_string_id_not_specified"));
        }
        if (Strings.isEmpty(this.languageId)) {
            errors.add(RESOURCE_BUNDLE.getString("error.comment_language_not_specified"));
        }
        if (Type.COMMENT.toString().equalsIgnoreCase(this.type) && !StringUtils.isEmpty(this.issueType)) {
            errors.add(RESOURCE_BUNDLE.getString("error.comment_should_not_have_issue_type"));
        } else {
            try {
                Type.from(this.type);
            }
            catch (Exception e) {
                errors.add(RESOURCE_BUNDLE.getString("error.comment_type_not_specified_or_incorrect"));
            }
        }
        return errors;
    }

    @Override
    protected NewAction<ProjectProperties, ProjectClient> getAction(Actions actions) {
        return actions.stringComment(this.plainView, this.text, this.stringId, this.languageId, this.type, this.issueType);
    }
}

