/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandProject;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="upload", sortOptions=false)
class FileUploadSubcommand
extends ActCommandProject {
    @CommandLine.Parameters(descriptionKey="crowdin.file.upload.file")
    protected File file;
    @CommandLine.Option(names={"-b", "--branch"}, paramLabel="...", order=-3)
    protected String branch;
    @CommandLine.Option(names={"--no-auto-update"}, descriptionKey="crowdin.file.upload.auto-update", negatable=true, order=-3)
    protected boolean autoUpdate = true;
    @CommandLine.Option(names={"--label"}, descriptionKey="params.label", paramLabel="...", order=-3)
    protected List<String> labels;
    @CommandLine.Option(names={"-d", "--dest"}, paramLabel="...", descriptionKey="crowdin.file.upload.dest", order=-3)
    protected String destination;
    @CommandLine.Option(names={"--context"}, descriptionKey="crowdin.file.upload.context", paramLabel="...", order=-2)
    protected String context;
    @CommandLine.Option(names={"--type"}, descriptionKey="crowdin.file.upload.type", paramLabel="...", order=-2)
    protected String type;
    @CommandLine.Option(names={"--parser-version"}, descriptionKey="crowdin.file.upload.parser", paramLabel="...", order=-2)
    protected Integer parserVersion;
    @CommandLine.Option(names={"--excluded-language"}, descriptionKey="params.excluded-languages", paramLabel="...", order=-3)
    protected List<String> excludedLanguages;
    @CommandLine.Option(names={"--cleanup-mode"}, negatable=true, descriptionKey="crowdin.file.upload.cleanup-mode", order=-3)
    protected boolean cleanupMode = false;
    @CommandLine.Option(names={"--update-strings"}, negatable=true, descriptionKey="crowdin.file.upload.update-strings", order=-3)
    protected boolean updateStrings = false;
    @CommandLine.Option(names={"-l", "--language"}, paramLabel="...", descriptionKey="crowdin.file.language", order=-3)
    protected String languageId;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;
    @CommandLine.Option(names={"--xliff"}, descriptionKey="crowdin.file.upload.xliff", order=-3)
    protected boolean xliff = false;

    FileUploadSubcommand() {
    }

    @Override
    protected List<String> checkOptions() {
        if (!this.file.exists()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(RESOURCE_BUNDLE.getString("error.file_not_found"), this.file));
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (this.parserVersion != null && this.type == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.type_required"));
        }
        if (this.file.isDirectory()) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.is_folder"));
        }
        if (this.xliff && this.languageId == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.language_xliff_required"));
        }
        if (this.xliff && this.destination != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.dest_with_xliff"));
        }
        return errors;
    }

    @Override
    protected NewAction<ProjectProperties, ProjectClient> getAction(Actions actions) {
        if (Objects.nonNull(this.languageId)) {
            return actions.fileUploadTranslation(this.file, this.branch, this.destination, this.languageId, this.xliff, this.plainView);
        }
        return actions.fileUpload(this.file, this.branch, this.autoUpdate, this.labels, this.destination, this.context, this.type, this.parserVersion, this.excludedLanguages, this.plainView, this.cleanupMode, this.updateStrings);
    }
}

