/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.functionality.FsFiles;
import com.crowdin.cli.commands.picocli.ActCommandGlossary;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.client.glossaries.model.GlossariesFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="download", sortOptions=false)
class GlossaryDownloadSubcommand
extends ActCommandGlossary {
    @CommandLine.Parameters(descriptionKey="crowdin.glossary.download.id")
    protected Long id;
    @CommandLine.Option(names={"--format"}, paramLabel="...", descriptionKey="crowdin.glossary.download.format", order=-2)
    private GlossariesFormat format;
    @CommandLine.Option(names={"--to"}, paramLabel="...", descriptionKey="crowdin.glossary.download.to", order=-2)
    private File to;

    GlossaryDownloadSubcommand() {
    }

    @Override
    protected NewAction<BaseProperties, ClientGlossary> getAction(Actions actions) {
        return actions.glossaryDownload(this.id, this.format, this.noProgress, this.to, new FsFiles());
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.to != null && this.format == null) {
            String extension = FilenameUtils.getExtension(this.to.getName());
            try {
                this.format = GlossariesFormat.from(extension);
            }
            catch (IllegalArgumentException e) {
                errors.add(RESOURCE_BUNDLE.getString("error.glossary.wrong_format"));
            }
        }
        return errors;
    }
}

