/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandWithFiles;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.translations.model.AutoApproveOption;
import com.crowdin.client.translations.model.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pre-translate", sortOptions=false)
public class PreTranslateSubcommand
extends ActCommandWithFiles {
    @CommandLine.Option(names={"-l", "--language"}, descriptionKey="crowdin.pre-translate.language", paramLabel="...", defaultValue="ALL", order=-2)
    protected List<String> languageIds;
    @CommandLine.Option(names={"--file"}, descriptionKey="crowdin.pre-translate.file", paramLabel="...", order=-2)
    protected List<String> files;
    @CommandLine.Option(names={"--method"}, descriptionKey="crowdin.pre-translate.method", paramLabel="...", required=true, order=-2)
    protected Method method;
    @CommandLine.Option(names={"--engine-id"}, descriptionKey="crowdin.pre-translate.engine-id", paramLabel="...", order=-2)
    protected Long engineId;
    @CommandLine.Option(names={"-b", "--branch"}, paramLabel="...", descriptionKey="branch", order=-2)
    protected String branch;
    @CommandLine.Option(names={"--directory"}, paramLabel="...", order=-2, descriptionKey="crowdin.pre-translate.directory-path")
    protected String directory;
    @CommandLine.Option(names={"--auto-approve-option"}, descriptionKey="crowdin.pre-translate.auto-approve-option", paramLabel="...", order=-2)
    protected String autoApproveOption;
    @CommandLine.Option(names={"--duplicate-translations"}, descriptionKey="crowdin.pre-translate.duplicate-translations", negatable=true, order=-2)
    protected Boolean duplicateTranslations;
    @CommandLine.Option(names={"--translate-untranslated-only"}, descriptionKey="crowdin.pre-translate.translate-untranslated-only", negatable=true, order=-2)
    protected Boolean translateUntranslatedOnly;
    @CommandLine.Option(names={"--translate-with-perfect-match-only"}, descriptionKey="crowdin.pre-translate.translate-with-perfect-match-only", negatable=true, order=-2)
    protected Boolean translateWithPerfectMatchOnly;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;
    @CommandLine.Option(names={"--label"}, descriptionKey="crowdin.pre-translate.label", paramLabel="...", order=-2)
    protected List<String> labelNames;
    @CommandLine.Option(names={"--ai-prompt"}, descriptionKey="crowdin.pre-translate.ai-prompt", paramLabel="...", order=-2)
    protected Long aiPrompt;
    private final Map<String, AutoApproveOption> autoApproveOptionWrapper = new HashMap<String, AutoApproveOption>(){
        {
            this.put("all", AutoApproveOption.ALL);
            this.put("except-auto-substituted", AutoApproveOption.EXCEPT_AUTO_SUBSTITUTED);
            this.put("perfect-match-only", AutoApproveOption.PERFECT_MATCH_ONLY);
            this.put("none", AutoApproveOption.NONE);
        }
    };

    @Override
    protected final boolean isAnsi() {
        return super.isAnsi() && !this.plainView;
    }

    @Override
    protected NewAction<PropertiesWithFiles, ProjectClient> getAction(Actions actions) {
        return actions.preTranslate(this.languageIds, this.files, this.method, this.engineId, this.branch, this.directory, this.autoApproveOptionWrapper.get(this.autoApproveOption), this.duplicateTranslations, this.translateUntranslatedOnly, this.translateWithPerfectMatchOnly, this.noProgress, this.plainView, this.labelNames, this.aiPrompt, this.isVerbose);
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.directory != null && this.files != null && !this.files.isEmpty()) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.directory_or_file_only"));
        }
        if (Method.MT == this.method && this.engineId == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.engine_id"));
        }
        if (Method.MT == this.method && this.duplicateTranslations != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.duplicate_translations"));
        }
        if (Method.MT == this.method && this.translateUntranslatedOnly != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.translate_untranslated_only"));
        }
        if (Method.MT == this.method && this.translateWithPerfectMatchOnly != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.translate_with_perfect_match_only"));
        }
        if (Method.MT == this.method && this.autoApproveOption != null) {
            System.out.println(ExecutionStatus.WARNING.withIcon(RESOURCE_BUNDLE.getString("message.warning.auto_approve_option_with_mt")));
            this.autoApproveOption = null;
        }
        if (this.autoApproveOption != null && !this.autoApproveOptionWrapper.containsKey(this.autoApproveOption)) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.auto_approve_option"));
        }
        if (Method.AI == this.method && this.aiPrompt == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.pre_translate.ai_prompt"));
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.size(); ++i) {
                String normalizedFile = StringUtils.removeStart(Utils.normalizePath(this.files.get(i)), Utils.PATH_SEPARATOR);
                this.files.set(i, normalizedFile);
            }
        }
        if (this.directory != null) {
            this.directory = StringUtils.removeStart(Utils.normalizePath(this.directory), Utils.PATH_SEPARATOR);
        }
        return errors;
    }
}

