/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientScreenshot;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandScreenshot;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="upload", sortOptions=false)
class ScreenshotUploadSubcommand
extends ActCommandScreenshot {
    @CommandLine.Parameters(descriptionKey="crowdin.screenshot.upload.file")
    protected File file;
    @CommandLine.Option(names={"--auto-tag"}, negatable=true, descriptionKey="crowdin.screenshot.upload.auto-tag", order=-2)
    protected boolean autoTag;
    @CommandLine.Option(names={"-f", "--file"}, paramLabel="...", descriptionKey="crowdin.screenshot.upload.file-path", order=-2)
    protected String filePath;
    @CommandLine.Option(names={"-b", "--branch"}, paramLabel="...", descriptionKey="crowdin.screenshot.upload.branch-name", order=-2)
    protected String branchName;
    @CommandLine.Option(names={"--label"}, paramLabel="...", descriptionKey="crowdin.screenshot.upload.label", order=-2)
    protected List<String> labelNames;
    @CommandLine.Option(names={"-d", "--directory"}, paramLabel="...", descriptionKey="crowdin.screenshot.upload.directory-path", order=-2)
    protected String directoryPath;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    ScreenshotUploadSubcommand() {
    }

    @Override
    protected NewAction<ProjectProperties, ClientScreenshot> getAction(Actions actions) {
        return actions.screenshotUpload(this.file, this.branchName, this.labelNames, this.directoryPath, this.filePath, this.autoTag, this.plainView, this.noProgress);
    }

    @Override
    protected List<String> checkOptions() {
        if (!this.file.exists()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(RESOURCE_BUNDLE.getString("error.file_not_found"), this.file));
        }
        ArrayList<String> errors = new ArrayList<String>();
        String extension = FilenameUtils.getExtension(this.file.getName());
        if (this.file.isDirectory()) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.is_folder"));
        }
        if (!this.equalsAny(extension, "jpeg", "jpg", "png", "gif")) {
            errors.add(RESOURCE_BUNDLE.getString("error.screenshot.wrong_format"));
        }
        if (Objects.nonNull(this.filePath) && !this.autoTag) {
            errors.add(RESOURCE_BUNDLE.getString("error.screenshot.auto-tag_required_for_file"));
        }
        if (Objects.nonNull(this.branchName) && !this.autoTag) {
            errors.add(RESOURCE_BUNDLE.getString("error.screenshot.auto-tag_required_for_branch"));
        }
        if (Objects.nonNull(this.directoryPath) && !this.autoTag) {
            errors.add(RESOURCE_BUNDLE.getString("error.screenshot.auto-tag_required_for_directory"));
        }
        if (Objects.nonNull(this.filePath) && (Objects.nonNull(this.directoryPath) || Objects.nonNull(this.branchName)) || Objects.nonNull(this.directoryPath) && Objects.nonNull(this.branchName)) {
            errors.add(RESOURCE_BUNDLE.getString("error.screenshot.only_one_allowed"));
        }
        return errors;
    }

    private boolean equalsAny(String toCheck, String ... strings) {
        for (String string : strings) {
            if (!StringUtils.equalsIgnoreCase(toCheck, string)) continue;
            return true;
        }
        return false;
    }
}

