/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientTask;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandTask;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.client.tasks.model.Status;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", sortOptions=false)
class TaskListSubcommand
extends ActCommandTask {
    @CommandLine.Option(names={"--status"}, paramLabel="...", descriptionKey="crowdin.task.list.status", order=-2)
    private String status;
    @CommandLine.Option(names={"--assignee-id"}, paramLabel="...", descriptionKey="crowdin.task.list.assignee-id", order=-2)
    private Long assigneeId;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    TaskListSubcommand() {
    }

    @Override
    protected NewAction<ProjectProperties, ClientTask> getAction(Actions actions) {
        return actions.taskList(this.plainView, this.isVerbose, this.status, this.assigneeId);
    }

    @Override
    protected boolean isAnsi() {
        return super.isAnsi() && !this.plainView;
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            if (this.status != null) {
                Status.valueOf(this.status.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            errors.add(String.format(RESOURCE_BUNDLE.getString("error.task.list.unsupported_status"), this.status));
        }
        return errors;
    }
}

