/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientTm;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.functionality.FsFiles;
import com.crowdin.cli.commands.picocli.ActCommandTm;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.client.translationmemory.model.TranslationMemoryFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="download", sortOptions=false)
class TmDownloadSubcommand
extends ActCommandTm {
    @CommandLine.Parameters(descriptionKey="crowdin.tm.download.id")
    protected Long id;
    @CommandLine.Option(names={"--source-language-id"}, paramLabel="...", descriptionKey="crowdin.tm.download.source-language-id", order=-2)
    private String sourceLanguageId;
    @CommandLine.Option(names={"--target-language-id"}, paramLabel="...", descriptionKey="crowdin.tm.download.target-language-id", order=-2)
    private String targetLanguageId;
    @CommandLine.Option(names={"--format"}, paramLabel="...", descriptionKey="crowdin.tm.download.format", order=-2)
    private TranslationMemoryFormat format;
    @CommandLine.Option(names={"--to"}, paramLabel="...", descriptionKey="crowdin.tm.download.to", order=-2)
    private File to;

    TmDownloadSubcommand() {
    }

    @Override
    protected NewAction<BaseProperties, ClientTm> getAction(Actions actions) {
        return actions.tmDownload(this.id, this.format, this.sourceLanguageId, this.targetLanguageId, this.noProgress, this.to, new FsFiles());
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.to != null && this.format == null) {
            String extension = FilenameUtils.getExtension(this.to.getName());
            try {
                this.format = TranslationMemoryFormat.from(extension);
            }
            catch (IllegalArgumentException e) {
                errors.add(RESOURCE_BUNDLE.getString("error.tm.wrong_format"));
            }
        }
        if (this.sourceLanguageId != null && this.targetLanguageId == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.target_language_id_is_null"));
        } else if (this.sourceLanguageId == null && this.targetLanguageId != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.source_language_id_is_null"));
        }
        return errors;
    }
}

