/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.Properties;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.properties.PropertiesConfigurator;
import com.crowdin.cli.properties.SettingsBean;
import com.crowdin.cli.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class BaseProperties
implements Properties {
    static BasePropertiesConfigurator CONFIGURATOR = new BasePropertiesConfigurator();
    private String apiToken;
    private String basePath;
    private String baseUrl;
    private SettingsBean settings;
    private String configFilePath;

    public String getApiToken() {
        return this.apiToken;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public SettingsBean getSettings() {
        return this.settings;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setSettings(SettingsBean settings) {
        this.settings = settings;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseProperties)) {
            return false;
        }
        BaseProperties other = (BaseProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiToken = this.getApiToken();
        String other$apiToken = other.getApiToken();
        if (this$apiToken == null ? other$apiToken != null : !this$apiToken.equals(other$apiToken)) {
            return false;
        }
        String this$basePath = this.getBasePath();
        String other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        SettingsBean this$settings = this.getSettings();
        SettingsBean other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        String this$configFilePath = this.getConfigFilePath();
        String other$configFilePath = other.getConfigFilePath();
        return !(this$configFilePath == null ? other$configFilePath != null : !this$configFilePath.equals(other$configFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiToken = this.getApiToken();
        result = result * 59 + ($apiToken == null ? 43 : $apiToken.hashCode());
        String $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        SettingsBean $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        String $configFilePath = this.getConfigFilePath();
        result = result * 59 + ($configFilePath == null ? 43 : $configFilePath.hashCode());
        return result;
    }

    public String toString() {
        return "BaseProperties(apiToken=" + this.getApiToken() + ", basePath=" + this.getBasePath() + ", baseUrl=" + this.getBaseUrl() + ", settings=" + String.valueOf(this.getSettings()) + ", configFilePath=" + this.getConfigFilePath() + ")";
    }

    static class BasePropertiesConfigurator
    implements PropertiesConfigurator<BaseProperties> {
        private BasePropertiesConfigurator() {
        }

        @Override
        public void populateWithValues(BaseProperties props, Map<String, Object> map) {
            PropertiesBuilder.setEnvOrPropertyIfExists(props::setApiToken, map, "api_token_env", "api_token");
            PropertiesBuilder.setEnvOrPropertyIfExists(props::setBasePath, map, "base_path_env", "base_path");
            PropertiesBuilder.setEnvOrPropertyIfExists(props::setBaseUrl, map, "base_url_env", "base_url");
            PropertiesBuilder.setPropertyIfExists(props::setConfigFilePath, map, "config_file_path", String.class);
            props.setSettings((SettingsBean)SettingsBean.CONFIGURATOR.buildFromMap((Map)PropertiesBuilder.getMap(map, "settings")));
        }

        @Override
        public void populateWithEnvValues(BaseProperties props) {
            if (props.getApiToken() == null) {
                PropertiesBuilder.setEnvIfExists(props::setApiToken, "CROWDIN_PERSONAL_TOKEN");
            }
            if (props.getBasePath() == null) {
                PropertiesBuilder.setEnvIfExists(props::setBasePath, "CROWDIN_BASE_PATH");
            }
            if (props.getBaseUrl() == null) {
                PropertiesBuilder.setEnvIfExists(props::setBaseUrl, "CROWDIN_BASE_URL");
            }
        }

        @Override
        public void populateWithDefaultValues(BaseProperties props) {
            String startDir;
            if (props == null) {
                return;
            }
            String string = startDir = props.getConfigFilePath() != null ? props.getConfigFilePath() : Paths.get(System.getProperty("user.dir"), new String[0]).toString();
            if (props.getBasePath() != null) {
                Path path;
                try {
                    path = Paths.get(startDir, new String[0]).resolve(props.getBasePath().replaceFirst("^~", System.getProperty("user.home"))).toRealPath(new LinkOption[0]);
                }
                catch (NoSuchFileException e) {
                    path = Paths.get(e.getMessage(), new String[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.while_checking_base_path"), e);
                }
                props.setBasePath(StringUtils.removeEnd(path.toString(), Utils.PATH_SEPARATOR) + Utils.PATH_SEPARATOR);
            } else {
                props.setBasePath(StringUtils.removeEnd(startDir, Utils.PATH_SEPARATOR) + Utils.PATH_SEPARATOR);
            }
            if (StringUtils.isNotEmpty(props.getBaseUrl())) {
                props.setBaseUrl(StringUtils.removePattern(props.getBaseUrl(), "/(api(/|/v2/?)?)?$"));
            } else {
                props.setBaseUrl(Utils.getBaseUrl());
            }
            if (props.getSettings() == null) {
                props.setSettings(new SettingsBean());
            }
            SettingsBean.CONFIGURATOR.populateWithDefaultValues(props.getSettings());
        }

        @Override
        public PropertiesBuilder.Messages checkProperties(@NonNull BaseProperties props, PropertiesConfigurator.CheckType checkType) {
            String confFilePath;
            if (props == null) {
                throw new NullPointerException("props is marked non-null but is null");
            }
            PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
            if (!(props.getApiToken() != null || (confFilePath = props.getConfigFilePath()) != null && new File(confFilePath).exists())) {
                throw new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.configuration_file_not_exist"));
            }
            if (StringUtils.isEmpty(props.getApiToken())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.missed_api_token"));
            }
            if (StringUtils.isEmpty(props.getBaseUrl())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.missed_base_url"));
            } else if (!PropertiesBeanUtils.isUrlValid(props.getBaseUrl())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.wrong_base_url"));
            }
            if (StringUtils.isNotEmpty(props.getBasePath())) {
                if (!PropertiesBuilder.checkBasePathExists(props.getBasePath())) {
                    messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_not_exist"), props.getBasePath()));
                } else if (!PropertiesBuilder.checkBasePathIsDir(props.getBasePath())) {
                    messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_is_not_dir"), props.getBasePath()));
                }
            } else {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_empty"));
            }
            messages.addAllErrors(SettingsBean.CONFIGURATOR.checkProperties(props.settings));
            return messages;
        }
    }
}

