/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.properties.PropertiesConfigurator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ProjectProperties
extends BaseProperties {
    static IdPropertiesConfigurator CONFIGURATOR = new IdPropertiesConfigurator();
    private String projectId;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectProperties)) {
            return false;
        }
        ProjectProperties other = (ProjectProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        return !(this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        return result;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String toString() {
        return "ProjectProperties(projectId=" + this.getProjectId() + ")";
    }

    static class IdPropertiesConfigurator
    implements PropertiesConfigurator<ProjectProperties> {
        private IdPropertiesConfigurator() {
        }

        @Override
        public void populateWithValues(ProjectProperties props, Map<String, Object> map) {
            PropertiesBuilder.setEnvOrPropertyIfExists(props::setProjectId, map, "project_id_env", "project_id");
        }

        @Override
        public void populateWithDefaultValues(ProjectProperties props) {
        }

        @Override
        public void populateWithEnvValues(ProjectProperties props) {
            if (props == null) {
                return;
            }
            if (props.getProjectId() == null) {
                PropertiesBuilder.setEnvIfExists(props::setProjectId, "CROWDIN_PROJECT_ID");
            }
        }

        @Override
        public PropertiesBuilder.Messages checkProperties(ProjectProperties props, PropertiesConfigurator.CheckType checkType) {
            PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
            if (StringUtils.isEmpty(props.getProjectId())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.missed_project_id"));
            } else if (!StringUtils.isNumeric(props.getProjectId())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.project_id_is_not_number"));
            }
            return messages;
        }
    }
}

