/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.AllProperties;
import com.crowdin.cli.properties.BaseParams;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.properties.BasePropertiesBuilder;
import com.crowdin.cli.properties.NoParams;
import com.crowdin.cli.properties.NoProperties;
import com.crowdin.cli.properties.ParamsWithFiles;
import com.crowdin.cli.properties.ProjectParams;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.properties.ProjectPropertiesBuilder;
import com.crowdin.cli.properties.PropertiesBuilderChecker;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.properties.PropertiesWithFilesBuilder;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.cli.utils.file.FileUtils;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PropertiesBuilders {
    private final boolean isVerbose;
    private final boolean isPlain;

    public PropertiesBuilders(boolean isVerbose, boolean isPlain) {
        this.isVerbose = isVerbose;
        this.isPlain = isPlain;
    }

    public PropertiesWithFiles buildPropertiesWithFiles(Outputter out, File configFile, File identityFile, ParamsWithFiles params) {
        return (PropertiesWithFiles)new PropertiesWithFilesBuilder(out).addConfigParams(this.fileExists(configFile) || params.isEmpty() ? this.readConfigFile(out, configFile, this.isParamsContainBasePath(params)) : null).addIdentityParams(identityFile != null ? this.loadCreds(identityFile, out) : null).addParams(params).build();
    }

    public ProjectProperties buildProjectProperties(Outputter out, File configFile, File identityFile, ProjectParams params) {
        return (ProjectProperties)new ProjectPropertiesBuilder(out).addConfigParams(this.fileExists(configFile) ? this.readConfigFile(out, configFile, this.isParamsContainBasePath(params)) : null).addIdentityParams(identityFile != null ? this.loadCreds(identityFile, out) : null).addParams(params).build();
    }

    public BaseProperties buildBaseProperties(Outputter out, File configFile, File identityFile, BaseParams params) {
        return (BaseProperties)new BasePropertiesBuilder(out).addConfigParams(this.fileExists(configFile) ? this.readConfigFile(out, configFile, this.isParamsContainBasePath(params)) : null).addIdentityParams(identityFile != null ? this.loadCreds(identityFile, out) : null).addParams(params).build();
    }

    public AllProperties buildChecker(Outputter out, File configFile, File identityFile, NoParams params) {
        return (AllProperties)new PropertiesBuilderChecker(out).addConfigParams(this.fileExists(configFile) ? this.readConfigFile(out, configFile, false) : null).addIdentityParams(identityFile != null ? this.loadCreds(identityFile, out) : null).addParams(params).build();
    }

    private Map<String, Object> readConfigFile(Outputter out, File configFile, boolean skipFilePath) {
        Map<String, Object> configFileParams = this.loadConfig(configFile, out);
        if (!skipFilePath) {
            configFileParams.put("config_file_path", configFile.getAbsoluteFile().getParentFile().getAbsolutePath());
        }
        return configFileParams;
    }

    private boolean isParamsContainBasePath(BaseParams params) {
        return params != null && StringUtils.isNotEmpty(params.getBasePathParam());
    }

    private boolean fileExists(File file) {
        return file != null && file.exists();
    }

    public NoProperties buildNoProperties() {
        return new NoProperties();
    }

    private Map<String, Object> loadConfig(File configFile, Outputter out) {
        return this.loadAndLog(configFile, out, "message.config.read");
    }

    private Map<String, Object> loadCreds(File configFile, Outputter out) {
        return this.loadAndLog(configFile, out, "message.creds.read");
    }

    private Map<String, Object> loadAndLog(File file, Outputter out, String messageTemplate) {
        if (this.isVerbose && !this.isPlain) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString(messageTemplate), file.getAbsolutePath())));
        }
        return FileUtils.readYamlFile(file);
    }
}

