/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.properties.PropertiesConfigurator;
import com.crowdin.cli.properties.PseudoLocalization;
import com.crowdin.client.languages.model.Language;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PropertiesWithFiles
extends ProjectProperties {
    static PropertiesWithFilesConfigurator CONFIGURATOR = new PropertiesWithFilesConfigurator();
    private Boolean preserveHierarchy;
    private List<FileBean> files;
    private PseudoLocalization pseudoLocalization;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertiesWithFiles)) {
            return false;
        }
        PropertiesWithFiles other = (PropertiesWithFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$preserveHierarchy = this.getPreserveHierarchy();
        Boolean other$preserveHierarchy = other.getPreserveHierarchy();
        if (this$preserveHierarchy == null ? other$preserveHierarchy != null : !((Object)this$preserveHierarchy).equals(other$preserveHierarchy)) {
            return false;
        }
        List<FileBean> this$files = this.getFiles();
        List<FileBean> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        PseudoLocalization this$pseudoLocalization = this.getPseudoLocalization();
        PseudoLocalization other$pseudoLocalization = other.getPseudoLocalization();
        return !(this$pseudoLocalization == null ? other$pseudoLocalization != null : !((Object)this$pseudoLocalization).equals(other$pseudoLocalization));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PropertiesWithFiles;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $preserveHierarchy = this.getPreserveHierarchy();
        result = result * 59 + ($preserveHierarchy == null ? 43 : ((Object)$preserveHierarchy).hashCode());
        List<FileBean> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        PseudoLocalization $pseudoLocalization = this.getPseudoLocalization();
        result = result * 59 + ($pseudoLocalization == null ? 43 : ((Object)$pseudoLocalization).hashCode());
        return result;
    }

    public Boolean getPreserveHierarchy() {
        return this.preserveHierarchy;
    }

    public List<FileBean> getFiles() {
        return this.files;
    }

    public PseudoLocalization getPseudoLocalization() {
        return this.pseudoLocalization;
    }

    public void setPreserveHierarchy(Boolean preserveHierarchy) {
        this.preserveHierarchy = preserveHierarchy;
    }

    public void setFiles(List<FileBean> files) {
        this.files = files;
    }

    public void setPseudoLocalization(PseudoLocalization pseudoLocalization) {
        this.pseudoLocalization = pseudoLocalization;
    }

    @Override
    public String toString() {
        return "PropertiesWithFiles(preserveHierarchy=" + this.getPreserveHierarchy() + ", files=" + String.valueOf(this.getFiles()) + ", pseudoLocalization=" + String.valueOf(this.getPseudoLocalization()) + ")";
    }

    static class PropertiesWithFilesConfigurator
    implements PropertiesConfigurator<PropertiesWithFiles> {
        private PropertiesWithFilesConfigurator() {
        }

        @Override
        public void populateWithValues(PropertiesWithFiles props, Map<String, Object> map) {
            PropertiesBuilder.setBooleanPropertyIfExists(props::setPreserveHierarchy, map, "preserve_hierarchy");
            props.setFiles(PropertiesBuilder.getListOfMaps(map, "files").stream().map(FileBean.CONFIGURATOR::buildFromMap).collect(Collectors.toList()));
            props.setPseudoLocalization((PseudoLocalization)PseudoLocalization.CONFIGURATOR.buildFromMap((Map)PropertiesBuilder.getMap(map, "pseudo_localization")));
        }

        @Override
        public void populateWithDefaultValues(PropertiesWithFiles props) {
            props.setPreserveHierarchy(props.getPreserveHierarchy() != null ? props.getPreserveHierarchy() : Boolean.FALSE);
            if (props.getSettings().getIgnoreHiddenFiles().booleanValue() && props.getFiles() != null) {
                for (FileBean fb : props.getFiles()) {
                    ArrayList<String> ignores = fb.getIgnore() != null ? fb.getIgnore() : new ArrayList<String>();
                    ignores.add("**/.*");
                    fb.setIgnore(ignores);
                }
            }
            if (props.getFiles() != null) {
                for (FileBean file : props.getFiles()) {
                    FileBean.CONFIGURATOR.populateWithDefaultValues(file);
                }
            }
            if (props.getPseudoLocalization() != null) {
                PseudoLocalization.CONFIGURATOR.populateWithDefaultValues(props.getPseudoLocalization());
            }
        }

        @Override
        public void populateWithEnvValues(PropertiesWithFiles props) {
        }

        @Override
        public PropertiesBuilder.Messages checkProperties(PropertiesWithFiles props, PropertiesConfigurator.CheckType checkType) {
            PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
            if (props.getFiles() == null || props.getFiles().isEmpty()) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.empty_or_missed_section_files"));
            } else {
                for (FileBean fileBean : props.getFiles()) {
                    ProjectClient projectClient;
                    List<Language> languages;
                    messages.addAllErrors(FileBean.CONFIGURATOR.checkProperties(fileBean));
                    if (StringUtils.isNotEmpty(fileBean.getDest()) && !props.getPreserveHierarchy().booleanValue()) {
                        messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.dest_and_preserve_hierarchy"));
                    }
                    if (fileBean.getLanguagesMapping() == null || (languages = (projectClient = GenericActCommand.getProjectClient(props)).listSupportedLanguages()) == null) continue;
                    Set langCodes = languages.stream().map(lang -> lang.getId().toLowerCase()).collect(Collectors.toSet());
                    boolean hasInvalidCode = fileBean.getLanguagesMapping().values().stream().flatMap(innerMap -> innerMap.keySet().stream()).anyMatch(langCode -> !langCodes.contains(langCode.toLowerCase()));
                    if (!hasInvalidCode) continue;
                    messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.languages_mapping"));
                }
            }
            if (props.getPseudoLocalization() != null) {
                messages.addAllErrors(PseudoLocalization.CONFIGURATOR.checkProperties(props.getPseudoLocalization()));
            }
            return messages;
        }
    }
}

