/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.ParamsWithFiles;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.properties.PropertiesConfigurator;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class PropertiesWithFilesBuilder
extends PropertiesBuilder<PropertiesWithFiles, ParamsWithFiles> {
    public PropertiesWithFilesBuilder(Outputter outputter) {
        super(outputter);
    }

    @Override
    protected PropertiesWithFiles getEmptyInstance() {
        return new PropertiesWithFiles();
    }

    @Override
    protected void populateWithIdentityFileParams(PropertiesWithFiles props, Map<String, Object> identityFileParams) {
        BaseProperties.CONFIGURATOR.populateWithValues(props, identityFileParams);
        ProjectProperties.CONFIGURATOR.populateWithValues(props, identityFileParams);
    }

    @Override
    protected void populateWithConfigFileParams(PropertiesWithFiles props, @NonNull Map<String, Object> configFileParams) {
        if (configFileParams == null) {
            throw new NullPointerException("configFileParams is marked non-null but is null");
        }
        if (configFileParams.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.empty_properties_file"));
        }
        BaseProperties.CONFIGURATOR.populateWithValues(props, configFileParams);
        ProjectProperties.CONFIGURATOR.populateWithValues(props, configFileParams);
        PropertiesWithFiles.CONFIGURATOR.populateWithValues(props, configFileParams);
    }

    @Override
    protected PropertiesBuilder.Messages checkArgParams(ParamsWithFiles params) {
        PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
        if (params == null) {
            return messages;
        }
        if (params.getBaseUrlParam() != null && !PropertiesBeanUtils.isUrlValid(params.getBaseUrlParam())) {
            messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.wrong_base_url"));
        }
        if (params.getBasePathParam() != null) {
            if (!PropertiesWithFilesBuilder.checkBasePathExists(params.getBasePathParam())) {
                messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_not_exist"), params.getBasePathParam()));
            } else if (!PropertiesWithFilesBuilder.checkBasePathIsDir(params.getBasePathParam())) {
                messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_is_not_dir"), params.getBasePathParam()));
            }
        }
        if (params.getSourceParam() != null && params.getTranslationParam() != null) {
            if (!PropertiesWithFilesBuilder.checkForDoubleAsterisks(params.getSourceParam(), params.getTranslationParam())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.double_asterisk"));
            }
            if (!PlaceholderUtil.containsLangPlaceholders(params.getTranslationParam())) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.translation_has_no_language_placeholders"));
            }
        } else {
            if (params.getSourceParam() != null ^ params.getTranslationParam() != null) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.params_xor_source_translation"));
            }
            if (params.getDestParam() != null) {
                messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.params_dest"));
            }
        }
        if (params.getSkipTranslatedOnly() != null && params.getSkipUntranslatedFiles() != null && params.getSkipTranslatedOnly().booleanValue() && params.getSkipUntranslatedFiles().booleanValue()) {
            messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.skip_untranslated_both_strings_and_files"));
        }
        return messages;
    }

    @Override
    protected void populateWithArgParams(@NonNull PropertiesWithFiles props, @NonNull ParamsWithFiles params) {
        if (props == null) {
            throw new NullPointerException("props is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (params.getSourceParam() != null && params.getTranslationParam() != null && new File(params.getSourceParam()).isAbsolute()) {
            String rootPath;
            props.setPreserveHierarchy(false);
            Path root = Paths.get(System.getProperty("user.dir"), new String[0]).getRoot();
            String string = rootPath = root != null ? root.toString() : "/";
            if (props.getBasePath() == null) {
                props.setBasePath(rootPath);
            }
            params.setSourceParam(StringUtils.removePattern(params.getSourceParam(), "^\\?([a-zA-Z]:)?[\\\\/]+"));
        }
        if (params.getIdParam() != null) {
            props.setProjectId(params.getIdParam());
        }
        if (params.getTokenParam() != null) {
            props.setApiToken(params.getTokenParam());
        }
        if (params.getBasePathParam() != null) {
            props.setBasePath(params.getBasePathParam());
        }
        if (params.getBaseUrlParam() != null) {
            props.setBaseUrl(params.getBaseUrlParam());
        }
        props.setPreserveHierarchy(params.getPreserveHierarchy() != null ? params.getPreserveHierarchy() : props.getPreserveHierarchy());
        if (params.getSourceParam() != null && params.getTranslationParam() != null) {
            FileBean fb = new FileBean();
            if (params.getSourceParam() != null) {
                fb.setSource(StringUtils.removePattern(params.getSourceParam(), "^\\?([a-zA-Z]:)?[\\\\/]+"));
            }
            if (params.getTranslationParam() != null) {
                fb.setTranslation(params.getTranslationParam());
            }
            if (params.getDestParam() != null) {
                props.setPreserveHierarchy(true);
                fb.setDest(params.getDestParam());
            }
            props.setFiles(Arrays.asList(fb));
        }
        for (FileBean fb : props.getFiles()) {
            if (params.getSkipTranslatedOnly() != null) {
                fb.setSkipTranslatedOnly(params.getSkipTranslatedOnly());
            }
            if (params.getSkipUntranslatedFiles() != null) {
                fb.setSkipUntranslatedFiles(params.getSkipUntranslatedFiles());
            }
            if (params.getExportApprovedOnly() != null) {
                fb.setExportApprovedOnly(params.getExportApprovedOnly());
            }
            if (params.getLabels() != null) {
                HashSet<String> labels = fb.getLabels() != null ? new HashSet<String>(fb.getLabels()) : new HashSet();
                labels.addAll(params.getLabels());
                fb.setLabels(new ArrayList<String>(labels));
            }
            if (params.getExcludedTargetLanguages() == null || params.getExcludedTargetLanguages().isEmpty()) continue;
            if (fb.getExcludedTargetLanguages() == null) {
                fb.setExcludedTargetLanguages(new ArrayList<String>());
            }
            for (String lang : params.getExcludedTargetLanguages()) {
                if (fb.getExcludedTargetLanguages().contains(lang)) continue;
                fb.getExcludedTargetLanguages().add(lang);
            }
        }
    }

    @Override
    protected void populateWithEnvValues(PropertiesWithFiles props) {
        if (props == null) {
            return;
        }
        BaseProperties.CONFIGURATOR.populateWithEnvValues(props);
        ProjectProperties.CONFIGURATOR.populateWithEnvValues(props);
        PropertiesWithFiles.CONFIGURATOR.populateWithEnvValues(props);
    }

    @Override
    protected void populateWithDefaultValues(PropertiesWithFiles props) {
        if (props == null) {
            return;
        }
        BaseProperties.CONFIGURATOR.populateWithDefaultValues(props);
        ProjectProperties.CONFIGURATOR.populateWithDefaultValues(props);
        PropertiesWithFiles.CONFIGURATOR.populateWithDefaultValues(props);
    }

    @Override
    protected PropertiesBuilder.Messages checkProperties(PropertiesWithFiles props) {
        PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
        if (props == null) {
            messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.property_bean_null"));
            return messages;
        }
        messages.populate(BaseProperties.CONFIGURATOR.checkProperties(props, PropertiesConfigurator.CheckType.STANDARD));
        messages.populate(ProjectProperties.CONFIGURATOR.checkProperties(props, PropertiesConfigurator.CheckType.STANDARD));
        messages.populate(PropertiesWithFiles.CONFIGURATOR.checkProperties(props, PropertiesConfigurator.CheckType.STANDARD));
        return messages;
    }
}

