/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.utils.PlaceholderUtil;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    private static final String APPLICATION_BASE_URL = "application.base_url";
    private static final String APPLICATION_NAME = "application.name";
    private static final String APPLICATION_VERSION = "application.version";
    public static final String PATH_SEPARATOR = FileSystems.getDefault().getSeparator();
    public static final String PATH_SEPARATOR_REGEX = "\\".equals(PATH_SEPARATOR) ? "\\\\" : PATH_SEPARATOR;
    public static final String PRESERVE_HIERARCHY_REGEX_PART = "(.*" + PATH_SEPARATOR_REGEX + ")?";
    private static final ResourceBundle CROWDIN_PROPERTIES = ResourceBundle.getBundle("crowdin");

    public static String getAppName() {
        return CROWDIN_PROPERTIES.getString(APPLICATION_NAME);
    }

    public static String getAppVersion() {
        return CROWDIN_PROPERTIES.getString(APPLICATION_VERSION);
    }

    public static String getLatestVersionUrl() {
        return CROWDIN_PROPERTIES.getString("application.version_file_url");
    }

    public static String getBaseUrl() {
        return CROWDIN_PROPERTIES.getString(APPLICATION_BASE_URL);
    }

    public static Boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static List<String> readResource(String path) {
        try {
            return IOUtils.readLines(Utils.class.getResourceAsStream(path), "UTF-8");
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.read_resource_file"), path), e);
        }
    }

    public static String buildUserAgent() {
        return String.format("%s/%s java/%s/%s %s/%s", Utils.getAppName(), Utils.getAppVersion(), System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"));
    }

    public static String toUnixPath(String path) {
        if (path == null) {
            return null;
        }
        return Utils.isWindows() != false ? path.replaceAll("[\\\\/]+", "/") : path.replaceAll("\\\\{2,}", "/").replaceAll("/+", "/");
    }

    public static String toWindowsPath(String path) {
        return path != null ? path.replaceAll("[\\\\/]+", "\\\\") : null;
    }

    public static String normalizePath(String path) {
        return path != null ? path.replaceAll("[\\\\/]+", PATH_SEPARATOR_REGEX) : null;
    }

    public static String noSepAtStart(String path) {
        return path != null ? path.replaceAll("^[\\\\/]+", "") : null;
    }

    public static String sepAtStart(String path) {
        return path != null ? PATH_SEPARATOR + Utils.noSepAtStart(path) : null;
    }

    public static String noSepAtEnd(String path) {
        return path != null ? path.replaceAll("[\\\\/]+$", "") : null;
    }

    public static String sepAtEnd(String path) {
        return path != null ? Utils.noSepAtEnd(path) + PATH_SEPARATOR : null;
    }

    public static String regexPath(String path) {
        if (path != null) {
            return path.replaceAll("\\\\", "\\\\\\\\").replace("(", PlaceholderUtil.ESCAPE_ROUND_BRACKET_OPEN).replace(")", PlaceholderUtil.ESCAPE_ROUND_BRACKET_CLOSE).replace("+", "\\+");
        }
        return null;
    }

    public static String joinPaths(String ... paths) {
        return String.join((CharSequence)PATH_SEPARATOR, paths).replaceAll("[\\\\/]+", PATH_SEPARATOR_REGEX);
    }

    public static String[] splitPath(String path) {
        return path.split("[\\\\/]+");
    }

    public static String getParentDirectory(String path) {
        if (!(path = Utils.noSepAtEnd(path)).contains(PATH_SEPARATOR)) {
            return PATH_SEPARATOR;
        }
        return path.substring(0, path.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    public static Optional<Pair<String, Integer>> proxyHost() {
        Integer port;
        if (System.getenv("HTTP_PROXY_HOST") == null || System.getenv("HTTP_PROXY_PORT") == null) {
            return Optional.empty();
        }
        try {
            port = Integer.valueOf(System.getenv("HTTP_PROXY_PORT"));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.of(new ImmutablePair<String, Integer>(System.getenv("HTTP_PROXY_HOST"), port));
    }

    public static Optional<Pair<String, String>> proxyCredentials() {
        if (System.getenv("HTTP_PROXY_USER") != null && System.getenv("HTTP_PROXY_PASSWORD") != null) {
            return Optional.of(new ImmutablePair<String, String>(System.getenv("HTTP_PROXY_USER"), System.getenv("HTTP_PROXY_PASSWORD")));
        }
        return Optional.empty();
    }

    public static String encodeURL(@NonNull String toEncode) {
        if (toEncode == null) {
            throw new NullPointerException("toEncode is marked non-null but is null");
        }
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toSingleLineString(String str) {
        return str.replaceAll("[\r\n]+", " ");
    }

    public static boolean isServerErrorCode(String code) {
        int statusCode;
        try {
            statusCode = Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return statusCode >= 500 && statusCode < 600;
    }
}

