/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.console;

import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ExecutionStatus;
import java.util.concurrent.locks.ReentrantLock;

class Spinner
extends Thread {
    private static final int SPINNER_INTERVAL = 250;
    private static final ReentrantLock lock = new ReentrantLock();
    private Outputter out;
    private int counter;
    private boolean isSpin;
    private String message;
    private boolean noProgress;
    private final String[] unixFrames = new String[]{"[\u25cf\u2219\u2219\u2219\u2219] ", "[\u2219\u25cf\u2219\u2219\u2219] ", "[\u2219\u2219\u25cf\u2219\u2219] ", "[\u2219\u2219\u2219\u25cf\u2219] ", "[\u2219\u2219\u2219\u2219\u25cf] "};
    private final String[] windowsFrames = new String[]{"[ \\ ] ", "[ | ] ", "[ / ] ", "[ - ] "};

    Spinner(Outputter out, String message, boolean noProgress) {
        this();
        this.out = out;
        this.message = message;
        this.noProgress = noProgress;
        this.isSpin = true;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private Spinner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.noProgress) {
            return;
        }
        lock.lock();
        try {
            String[] frames = this.getFrames();
            while (this.isSpin) {
                String frame = frames[this.counter++ % frames.length] + this.message;
                this.out.print(frame);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.clearFrame(frame);
            }
        }
        finally {
            lock.unlock();
        }
    }

    void stopSpinning(ExecutionStatus status) {
        this.stopSpinning(status, this.message);
    }

    void stopSpinning(ExecutionStatus status, String stopMessage) {
        this.isSpin = false;
        lock.lock();
        try {
            this.out.println(status.withIcon(stopMessage));
        }
        finally {
            lock.unlock();
        }
    }

    private String[] getFrames() {
        return Utils.isWindows() != false ? this.windowsFrames : this.unixFrames;
    }

    private void clearFrame(String frame) {
        int bound = frame.length();
        for (int value = 0; value < bound; ++value) {
            this.out.print("\b \b");
        }
    }
}

