/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.http;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

class HttpResponse {
    private String code;
    private Map<String, String> headers;
    private String body;

    public void send(PrintWriter out) {
        out.println("HTTP/1.1 " + this.code);
        if (this.headers != null) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                out.println(String.format("%s: %s", header.getKey(), header.getValue()));
            }
        }
        out.println();
        if (this.body != null) {
            out.println(this.body);
        }
        out.flush();
    }

    public static HttpResponse redirect(String url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Location", url);
        return new HttpResponse("301", headers, null);
    }

    public static HttpResponse notFoundHtml(String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/html; charset=utf-8");
        return new HttpResponse("404 Not Found", headers, body);
    }

    public static HttpResponse ok(String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/html; charset=utf-8");
        return new HttpResponse("200", headers, body);
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(code=" + this.getCode() + ", headers=" + String.valueOf(this.getHeaders()) + ", body=" + this.getBody() + ")";
    }

    protected HttpResponse(String code, Map<String, String> headers, String body) {
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    protected HttpResponse() {
    }
}

