/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.http;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.cli.utils.http.HttpResponse;
import com.crowdin.cli.utils.http.ServerSocketFactory;
import com.crowdin.cli.utils.http.SimpleHttpServer;
import java.awt.Desktop;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthUtil {
    public static String getToken(Outputter out, String clientId) {
        try {
            int port = 46221;
            String redirectUri = String.format("http://localhost:%d/callback", port);
            ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
            SimpleHttpServer server = new SimpleHttpServer(ServerSocketFactory.standard(), port, true);
            server.addListener("/callback", (request, responseOut) -> {
                Result result;
                String responseText = BaseCli.RESOURCE_BUNDLE.getString("message.html_page.main_text_exception");
                if (request.getParams().containsKey("access_token") && request.getParams().containsKey("expires_in")) {
                    String accessToken = request.getParams().get("access_token");
                    int expiresIn = Integer.parseInt(request.getParams().get("expires_in"));
                    result = new Result(accessToken, expiresIn);
                    responseText = BaseCli.RESOURCE_BUNDLE.getString("message.html_page.main_text_successful");
                } else {
                    result = request.getParams().containsKey("error") ? new Result(new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.error_response"), "https://accounts.crowdin.com/oauth/authorize?client_id=%s&redirect_uri=%s&response_type=token&scope=project", request.getParams().get("error")))) : new Result(new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.unexpected_response"), "https://accounts.crowdin.com/oauth/authorize?client_id=%s&redirect_uri=%s&response_type=token&scope=project", request)));
                }
                HttpResponse.ok(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.html_page.body"), BaseCli.RESOURCE_BUNDLE.getString("message.html_page.title"), responseText, BaseCli.RESOURCE_BUNDLE.getString("message.html_page.close_page_text"))).send(responseOut);
                queue.add(result);
            });
            server.setDaemon(true);
            server.start();
            String builtUrl = String.format("https://accounts.crowdin.com/oauth/authorize?client_id=%s&redirect_uri=%s&response_type=token&scope=project", clientId, redirectUri);
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(builtUrl));
            } else {
                out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.warning.browser_not_found"), builtUrl)));
            }
            Result result = (Result)queue.take();
            server.close();
            if (result.getToken() != null) {
                return result.getToken();
            }
            if (result.getException() != null) {
                throw result.getException();
            }
            throw new RuntimeException("Unexpected error");
        }
        catch (Exception e) {
            throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.in_local_server"), e);
        }
    }

    public static String getDomainFromToken(String token) {
        String[] parts;
        for (String part : parts = token.split("\\.")) {
            try {
                String decoded = new String(Base64.decodeBase64(part.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                JSONObject decodedJson = new JSONObject(decoded);
                if (!decodedJson.has("domain")) continue;
                return decodedJson.getString("domain");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class Result {
        private String token;
        private int expiresIn;
        private Exception exception;

        public Result(String token, int expiresIn) {
            this.token = token;
            this.expiresIn = expiresIn;
        }

        public Result(Exception exception) {
            this.exception = exception;
        }

        public String getToken() {
            return this.token;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setExpiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpiresIn() != other.getExpiresIn()) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            Exception this$exception = this.getException();
            Exception other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpiresIn();
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            Exception $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        public String toString() {
            return "OAuthUtil.Result(token=" + this.getToken() + ", expiresIn=" + this.getExpiresIn() + ", exception=" + String.valueOf(this.getException()) + ")";
        }
    }
}

