/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.tree;

import com.crowdin.cli.utils.tree.Visitable;
import com.crowdin.cli.utils.tree.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class Tree<T>
implements Visitable<T> {
    private final Set<Tree<T>> children = new LinkedHashSet<Tree<T>>();
    private Tree<T> lastChild;
    private final T data;

    Tree(T data) {
        this.data = data;
    }

    @Override
    public <E> List<E> accept(Visitor<T, E> visitor) {
        ArrayList<E> result = new ArrayList<E>();
        result.add(visitor.visitData(this, this.data));
        for (Tree<T> child : this.children) {
            Visitor<T, E> childVisitor = visitor.visitTree(child, false);
            result.addAll(child.accept(childVisitor));
        }
        if (this.lastChild != null) {
            Visitor<T, E> childVisitor = visitor.visitTree(this.lastChild, true);
            result.addAll(this.lastChild.accept(childVisitor));
        }
        return result;
    }

    public Tree<T> child(T data) {
        for (Tree<T> child : this.children) {
            if (!child.data.equals(data)) continue;
            return child;
        }
        if (this.lastChild != null && this.lastChild.data.equals(data)) {
            return this.lastChild;
        }
        if (this.lastChild != null) {
            this.children.add(this.lastChild);
        }
        this.lastChild = new Tree<T>(data);
        return this.lastChild;
    }
}

