/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.branches;

import com.crowdin.client.branches.model.BranchCloneStatus;
import com.crowdin.client.branches.model.BranchCloneStatusResponseObject;
import com.crowdin.client.branches.model.BranchMergeStatus;
import com.crowdin.client.branches.model.BranchMergeStatusResponseObject;
import com.crowdin.client.branches.model.BranchMergeSummary;
import com.crowdin.client.branches.model.BranchMergeSummaryResponseObject;
import com.crowdin.client.branches.model.CloneBranchRequest;
import com.crowdin.client.branches.model.ClonedBranch;
import com.crowdin.client.branches.model.ClonedBranchResponseObject;
import com.crowdin.client.branches.model.MergeBranchRequest;
import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.ResponseObject;

public class BranchesApi
extends CrowdinApi {
    public BranchesApi(Credentials credentials) {
        super(credentials);
    }

    public BranchesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseObject<BranchCloneStatus> cloneBranch(Long projectId, Long branchId, CloneBranchRequest request) throws HttpException, HttpBadRequestException {
        BranchCloneStatusResponseObject branchResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/branches/" + branchId + "/clones", request, new HttpRequestConfig(), BranchCloneStatusResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<BranchCloneStatus> checkCloneBranchStatus(Long projectId, Long branchId, String cloneId) throws HttpException, HttpBadRequestException {
        BranchCloneStatusResponseObject branchResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/branches/" + branchId + "/clones/" + cloneId, new HttpRequestConfig(), BranchCloneStatusResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<ClonedBranch> getClonedBranch(Long projectId, Long branchId, String cloneId) throws HttpException, HttpBadRequestException {
        ClonedBranchResponseObject branchResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/branches/" + branchId + "/clones/" + cloneId + "/branch", new HttpRequestConfig(), ClonedBranchResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<BranchMergeStatus> mergeBranch(Long projectId, Long branchId, MergeBranchRequest request) throws HttpException, HttpBadRequestException {
        BranchMergeStatusResponseObject branchResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/branches/" + branchId + "/merges", request, new HttpRequestConfig(), BranchMergeStatusResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<BranchMergeStatus> checkMergeBranchStatus(Long projectId, Long branchId, String mergeId) throws HttpException, HttpBadRequestException {
        BranchMergeStatusResponseObject branchResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/branches/" + branchId + "/merges/" + mergeId, new HttpRequestConfig(), BranchMergeStatusResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<BranchMergeSummary> getMergeBranchSummary(Long projectId, Long branchId, String mergeId) throws HttpException, HttpBadRequestException {
        BranchMergeSummaryResponseObject branchResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/branches/" + branchId + "/merges/" + mergeId + "/summary", new HttpRequestConfig(), BranchMergeSummaryResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }
}

