/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.bundles;

import com.crowdin.client.bundles.model.AddBundleRequest;
import com.crowdin.client.bundles.model.Bundle;
import com.crowdin.client.bundles.model.BundleExport;
import com.crowdin.client.bundles.model.BundleExportResponseObject;
import com.crowdin.client.bundles.model.BundleResponseList;
import com.crowdin.client.bundles.model.BundleResponseObject;
import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.Pagination;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.BranchResponseList;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.FileInfoResponseList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BundlesApi
extends CrowdinApi {
    public BundlesApi(Credentials credentials) {
        super(credentials);
    }

    public BundlesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Bundle> listBundles(Long projectId) throws HttpException, HttpBadRequestException {
        return this.listBundles(projectId, new Pagination());
    }

    public ResponseList<Bundle> listBundles(Long projectId, Pagination options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        BundleResponseList response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles", new HttpRequestConfig(queryParams), BundleResponseList.class);
        return BundleResponseList.to(response);
    }

    public ResponseObject<Bundle> addBundle(Long projectId, AddBundleRequest request) throws HttpException, HttpBadRequestException {
        BundleResponseObject response = this.httpClient.post(this.url + "/projects/" + projectId + "/bundles", request, new HttpRequestConfig(), BundleResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<Bundle> getBundle(Long projectId, Long bundleId) throws HttpException, HttpBadRequestException {
        BundleResponseObject response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles/" + bundleId, new HttpRequestConfig(), BundleResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteBundle(Long projectId, Long bundleId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/bundles/" + bundleId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Bundle> editBundle(Long projectId, Long bundleId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        BundleResponseObject response = this.httpClient.patch(this.url + "/projects/" + projectId + "/bundles/" + bundleId, request, new HttpRequestConfig(), BundleResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<? extends FileInfo> listBundleFiles(Long projectId, Long bundleId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        FileInfoResponseList response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles/" + bundleId + "/files", new HttpRequestConfig(queryParams), FileInfoResponseList.class);
        return FileInfoResponseList.to(response);
    }

    public ResponseList<Branch> listBundleBranches(Long projectId, Long bundleId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        BranchResponseList response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles/" + bundleId + "/branches", new HttpRequestConfig(queryParams), BranchResponseList.class);
        return BranchResponseList.to(response);
    }

    public ResponseObject<DownloadLink> downloadBundle(Long projectId, Long bundleId, String exportId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles/" + bundleId + "/exports/" + exportId + "/download", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<BundleExport> exportBundle(Long projectId, Long bundleId) throws HttpException, HttpBadRequestException {
        BundleExportResponseObject response = this.httpClient.post(this.url + "/projects/" + projectId + "/bundles/" + bundleId + "/exports", null, new HttpRequestConfig(), BundleExportResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<BundleExport> checkBundleExportStatus(Long projectId, Long bundleId, String exportId) {
        BundleExportResponseObject response = this.httpClient.get(this.url + "/projects/" + projectId + "/bundles/" + bundleId + "/exports/" + exportId, new HttpRequestConfig(), BundleExportResponseObject.class);
        return ResponseObject.of(response.getData());
    }
}

