/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.glossaries;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.glossaries.model.AddGlossaryRequest;
import com.crowdin.client.glossaries.model.AddTermRequest;
import com.crowdin.client.glossaries.model.Concept;
import com.crowdin.client.glossaries.model.ConceptResponseList;
import com.crowdin.client.glossaries.model.ConceptResponseObject;
import com.crowdin.client.glossaries.model.ExportGlossaryRequest;
import com.crowdin.client.glossaries.model.Glossary;
import com.crowdin.client.glossaries.model.GlossaryExportStatus;
import com.crowdin.client.glossaries.model.GlossaryExportStatusResponseObject;
import com.crowdin.client.glossaries.model.GlossaryImportStatus;
import com.crowdin.client.glossaries.model.GlossaryImportStatusResponseObject;
import com.crowdin.client.glossaries.model.GlossaryResponseList;
import com.crowdin.client.glossaries.model.GlossaryResponseObject;
import com.crowdin.client.glossaries.model.ImportGlossaryRequest;
import com.crowdin.client.glossaries.model.ListConceptsParams;
import com.crowdin.client.glossaries.model.ListGlossariesParams;
import com.crowdin.client.glossaries.model.ListTermsParams;
import com.crowdin.client.glossaries.model.SearchConcordance;
import com.crowdin.client.glossaries.model.SearchConcordanceRequest;
import com.crowdin.client.glossaries.model.SearchConcordanceResponseList;
import com.crowdin.client.glossaries.model.Term;
import com.crowdin.client.glossaries.model.TermResponseList;
import com.crowdin.client.glossaries.model.TermResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GlossariesApi
extends CrowdinApi {
    public GlossariesApi(Credentials credentials) {
        super(credentials);
    }

    public GlossariesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<SearchConcordance> searchConcordance(Long projectId, SearchConcordanceRequest request) {
        SearchConcordanceResponseList searchConcordanceResponseList = this.httpClient.post(this.url + "/projects/" + projectId + "/glossaries/concordance", request, new HttpRequestConfig(), SearchConcordanceResponseList.class);
        return SearchConcordanceResponseList.of(searchConcordanceResponseList);
    }

    public ResponseList<Concept> listConcepts(Long glossaryId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListConceptsParams params = new ListConceptsParams();
        params.setLimit(limit);
        params.setOffset(offset);
        return this.listConcepts(glossaryId, params);
    }

    public ResponseList<Concept> listConcepts(Long glossaryId, ListConceptsParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("orderBy", Optional.ofNullable(params.getOrderBy()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        ConceptResponseList conceptResponseList = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/concepts", new HttpRequestConfig(queryParams), ConceptResponseList.class);
        return ConceptResponseList.to(conceptResponseList);
    }

    public ResponseObject<Concept> getConcept(Long glossaryId, Long conceptId) throws HttpException, HttpBadRequestException {
        ConceptResponseObject conceptResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/concepts/" + conceptId, new HttpRequestConfig(), ConceptResponseObject.class);
        return ResponseObject.of(conceptResponseObject.getData());
    }

    public ResponseObject<Concept> updateConcept(Long glossaryId, Long conceptId, Concept request) throws HttpException, HttpBadRequestException {
        ConceptResponseObject conceptResponseObject = this.httpClient.put(this.url + "/glossaries/" + glossaryId + "/concepts/" + conceptId, request, new HttpRequestConfig(), ConceptResponseObject.class);
        return ResponseObject.of(conceptResponseObject.getData());
    }

    public void deleteConcept(Long glossaryId, Long conceptId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/glossaries/" + glossaryId + "/concepts/" + conceptId, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<Glossary> listGlossaries(Long groupId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListGlossariesParams params = new ListGlossariesParams();
        params.setGroupId(groupId);
        params.setLimit(limit);
        params.setOffset(offset);
        return this.listGlossaries(params);
    }

    public ResponseList<Glossary> listGlossaries(ListGlossariesParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("groupId", Optional.ofNullable(params.getGroupId()), "userId", Optional.ofNullable(params.getUserId()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        GlossaryResponseList glossaryResponseList = this.httpClient.get(this.url + "/glossaries", new HttpRequestConfig(queryParams), GlossaryResponseList.class);
        return GlossaryResponseList.to(glossaryResponseList);
    }

    public ResponseObject<Glossary> addGlossary(AddGlossaryRequest request) throws HttpException, HttpBadRequestException {
        GlossaryResponseObject glossaryResponseObject = this.httpClient.post(this.url + "/glossaries", request, new HttpRequestConfig(), GlossaryResponseObject.class);
        return ResponseObject.of(glossaryResponseObject.getData());
    }

    public ResponseObject<Glossary> getGlossary(Long glossaryId) throws HttpException, HttpBadRequestException {
        GlossaryResponseObject glossaryResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId, new HttpRequestConfig(), GlossaryResponseObject.class);
        return ResponseObject.of(glossaryResponseObject.getData());
    }

    public void deleteGlossary(Long glossaryId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/glossaries/" + glossaryId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Glossary> editGlossary(Long glossaryId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        GlossaryResponseObject glossaryResponseObject = this.httpClient.patch(this.url + "/glossaries/" + glossaryId, request, new HttpRequestConfig(), GlossaryResponseObject.class);
        return ResponseObject.of(glossaryResponseObject.getData());
    }

    public ResponseObject<GlossaryExportStatus> exportGlossary(Long glossaryId, ExportGlossaryRequest request) throws HttpException, HttpBadRequestException {
        GlossaryExportStatusResponseObject glossaryExportStatusResponseObject = this.httpClient.post(this.url + "/glossaries/" + glossaryId + "/exports", request, new HttpRequestConfig(), GlossaryExportStatusResponseObject.class);
        return ResponseObject.of(glossaryExportStatusResponseObject.getData());
    }

    public ResponseObject<GlossaryExportStatus> checkGlossaryExportStatus(Long glossaryId, String exportId) throws HttpException, HttpBadRequestException {
        GlossaryExportStatusResponseObject glossaryExportStatusResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/exports/" + exportId, new HttpRequestConfig(), GlossaryExportStatusResponseObject.class);
        return ResponseObject.of(glossaryExportStatusResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadGlossary(Long glossaryId, String exportId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/exports/" + exportId + "/download", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseObject<GlossaryImportStatus> importGlossary(Long glossaryId, ImportGlossaryRequest request) throws HttpException, HttpBadRequestException {
        GlossaryImportStatusResponseObject glossaryImportStatusResponseObject = this.httpClient.post(this.url + "/glossaries/" + glossaryId + "/imports", request, new HttpRequestConfig(), GlossaryImportStatusResponseObject.class);
        return ResponseObject.of(glossaryImportStatusResponseObject.getData());
    }

    public ResponseObject<GlossaryImportStatus> checkGlossaryImportStatus(Long glossaryId, String importId) throws HttpException, HttpBadRequestException {
        GlossaryImportStatusResponseObject glossaryImportStatusResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/imports/" + importId, new HttpRequestConfig(), GlossaryImportStatusResponseObject.class);
        return ResponseObject.of(glossaryImportStatusResponseObject.getData());
    }

    public ResponseList<Term> listTerms(Long glossaryId, Long userId, String languageId, Long conceptId, @Deprecated Long translationOfTermId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListTermsParams params = new ListTermsParams();
        params.setUserId(userId);
        params.setLanguageId(languageId);
        params.setConceptId(conceptId);
        params.setTranslationOfTermId(translationOfTermId);
        params.setLimit(limit);
        params.setOffset(offset);
        return this.listTerms(glossaryId, params);
    }

    public ResponseList<Term> listTerms(Long glossaryId, ListTermsParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("orderBy", Optional.ofNullable(params.getOrderBy()), "userId", Optional.ofNullable(params.getUserId()), "languageId", Optional.ofNullable(params.getLanguageId()), "conceptId", Optional.ofNullable(params.getConceptId()), "translationOfTermId", Optional.ofNullable(params.getTranslationOfTermId()), "croql", Optional.ofNullable(params.getCroql()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        TermResponseList termResponseList = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/terms", new HttpRequestConfig(queryParams), TermResponseList.class);
        return TermResponseList.to(termResponseList);
    }

    public ResponseObject<Term> addTerm(Long glossaryId, AddTermRequest request) throws HttpException, HttpBadRequestException {
        TermResponseObject termResponseObject = this.httpClient.post(this.url + "/glossaries/" + glossaryId + "/terms", request, new HttpRequestConfig(), TermResponseObject.class);
        return ResponseObject.of(termResponseObject.getData());
    }

    public void clearGlossary(Long glossaryId, String languageId, Long conceptId, @Deprecated Long translationOfTermId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Long>> queryParams = HttpRequestConfig.buildUrlParams("languageId", Optional.ofNullable(languageId), "conceptId", Optional.ofNullable(conceptId), "translationOfTermId", Optional.ofNullable(translationOfTermId));
        this.httpClient.delete(this.url + "/glossaries/" + glossaryId + "/terms", new HttpRequestConfig(queryParams), Void.class);
    }

    public ResponseObject<Term> getTerm(Long glossaryId, Long termId) throws HttpException, HttpBadRequestException {
        TermResponseObject termResponseObject = this.httpClient.get(this.url + "/glossaries/" + glossaryId + "/terms/" + termId, new HttpRequestConfig(), TermResponseObject.class);
        return ResponseObject.of(termResponseObject.getData());
    }

    public void deleteTerm(Long glossaryId, Long termId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/glossaries/" + glossaryId + "/terms/" + termId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Term> editTerm(Long glossaryId, Long termId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        TermResponseObject termResponseObject = this.httpClient.patch(this.url + "/glossaries/" + glossaryId + "/terms/" + termId, request, new HttpRequestConfig(), TermResponseObject.class);
        return ResponseObject.of(termResponseObject.getData());
    }
}

