/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.machinetranslationengines;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.machinetranslationengines.model.AddMachineTranslationRequest;
import com.crowdin.client.machinetranslationengines.model.MachineTranslation;
import com.crowdin.client.machinetranslationengines.model.MachineTranslationResponseList;
import com.crowdin.client.machinetranslationengines.model.MachineTranslationResponseObject;
import com.crowdin.client.machinetranslationengines.model.MtTranslateRequest;
import com.crowdin.client.machinetranslationengines.model.MtTranslateResponse;
import com.crowdin.client.machinetranslationengines.model.MtTranslateResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MachineTranslationEnginesApi
extends CrowdinApi {
    public MachineTranslationEnginesApi(Credentials credentials) {
        super(credentials);
    }

    public MachineTranslationEnginesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<MachineTranslation> listMts(Long groupId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("groupId", Optional.ofNullable(groupId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        MachineTranslationResponseList machineTranslationResponseList = this.httpClient.get(this.url + "/mts", new HttpRequestConfig(queryParams), MachineTranslationResponseList.class);
        return MachineTranslationResponseList.to(machineTranslationResponseList);
    }

    public ResponseObject<MachineTranslation> addMt(AddMachineTranslationRequest request) throws HttpException, HttpBadRequestException {
        MachineTranslationResponseObject machineTranslationResponseObject = this.httpClient.post(this.url + "/mts", request, new HttpRequestConfig(), MachineTranslationResponseObject.class);
        return ResponseObject.of(machineTranslationResponseObject.getData());
    }

    public ResponseObject<MachineTranslation> getMt(Long mtId) throws HttpException, HttpBadRequestException {
        MachineTranslationResponseObject machineTranslationResponseObject = this.httpClient.get(this.url + "/mts/" + mtId, new HttpRequestConfig(), MachineTranslationResponseObject.class);
        return ResponseObject.of(machineTranslationResponseObject.getData());
    }

    public void deleteMt(Long mtId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/mts/" + mtId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<MachineTranslation> editMt(Long mtId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        MachineTranslationResponseObject machineTranslationResponseObject = this.httpClient.patch(this.url + "/mts/" + mtId, request, new HttpRequestConfig(), MachineTranslationResponseObject.class);
        return ResponseObject.of(machineTranslationResponseObject.getData());
    }

    public ResponseObject<MtTranslateResponse> translateViaMt(Long mtId, MtTranslateRequest request) throws HttpException, HttpBadRequestException {
        MtTranslateResponseObject mtTranslateResponseObject = this.httpClient.post(this.url + "/mts/" + mtId + "/translations", request, new HttpRequestConfig(), MtTranslateResponseObject.class);
        return ResponseObject.of(mtTranslateResponseObject.getData());
    }
}

