/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.projectsgroups;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.projectsgroups.model.AddGroupRequest;
import com.crowdin.client.projectsgroups.model.AddProjectFileFormatSettingsRequest;
import com.crowdin.client.projectsgroups.model.AddProjectRequest;
import com.crowdin.client.projectsgroups.model.FileFormatSettingsResource;
import com.crowdin.client.projectsgroups.model.FileFormatSettingsResponseList;
import com.crowdin.client.projectsgroups.model.FileFormatSettingsResponseObject;
import com.crowdin.client.projectsgroups.model.Group;
import com.crowdin.client.projectsgroups.model.GroupResponseList;
import com.crowdin.client.projectsgroups.model.GroupResponseObject;
import com.crowdin.client.projectsgroups.model.ListGroupOptions;
import com.crowdin.client.projectsgroups.model.ListProjectOptions;
import com.crowdin.client.projectsgroups.model.Project;
import com.crowdin.client.projectsgroups.model.ProjectResponseList;
import com.crowdin.client.projectsgroups.model.ProjectResponseObject;
import com.crowdin.client.projectsgroups.model.StringsExporterSettingsRequest;
import com.crowdin.client.projectsgroups.model.StringsExporterSettingsResource;
import com.crowdin.client.projectsgroups.model.StringsExporterSettingsResponseList;
import com.crowdin.client.projectsgroups.model.StringsExporterSettingsResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ProjectsGroupsApi
extends CrowdinApi {
    public ProjectsGroupsApi(Credentials credentials) {
        super(credentials);
    }

    public ProjectsGroupsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Group> listGroups(Long parentId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListGroupOptions options = new ListGroupOptions();
        options.setParentId(parentId);
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listGroups(options);
    }

    public ResponseList<Group> listGroups(ListGroupOptions options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("parentId", Optional.ofNullable(options.getParentId()), "userId", Optional.ofNullable(options.getUserId()), "orderBy", Optional.ofNullable(options.getOrderBy()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        GroupResponseList groupResponseList = this.httpClient.get(this.url + "/groups", new HttpRequestConfig(queryParams), GroupResponseList.class);
        return GroupResponseList.to(groupResponseList);
    }

    public ResponseObject<Group> addGroup(AddGroupRequest request) throws HttpException, HttpBadRequestException {
        GroupResponseObject groupResponseObject = this.httpClient.post(this.url + "/groups", request, new HttpRequestConfig(), GroupResponseObject.class);
        return ResponseObject.of(groupResponseObject.getData());
    }

    public ResponseObject<Group> getGroup(Long groupId) throws HttpException, HttpBadRequestException {
        GroupResponseObject groupResponseObject = this.httpClient.get(this.url + "/groups/" + groupId, new HttpRequestConfig(), GroupResponseObject.class);
        return ResponseObject.of(groupResponseObject.getData());
    }

    public void deleteGroup(Long groupId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/groups/" + groupId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Group> editGroup(Long groupId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        GroupResponseObject groupResponseObject = this.httpClient.patch(this.url + "/groups/" + groupId, request, new HttpRequestConfig(), GroupResponseObject.class);
        return ResponseObject.of(groupResponseObject.getData());
    }

    public ResponseList<? extends Project> listProjects(Long groupId, Integer hasManagerAccess, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListProjectOptions options = new ListProjectOptions();
        options.setGroupId(groupId);
        options.setHasManagerAccess(hasManagerAccess);
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listProjects(options);
    }

    public ResponseList<? extends Project> listProjects(ListProjectOptions options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("groupId", Optional.ofNullable(options.getGroupId()), "hasManagerAccess", Optional.ofNullable(options.getHasManagerAccess()), "orderBy", Optional.ofNullable(options.getOrderBy()), "type", Optional.ofNullable(options.getType()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        ProjectResponseList projectResponseList = this.httpClient.get(this.url + "/projects", new HttpRequestConfig(queryParams), ProjectResponseList.class);
        return ProjectResponseList.to(projectResponseList);
    }

    public ResponseObject<? extends Project> addProject(AddProjectRequest request) throws HttpException, HttpBadRequestException {
        ProjectResponseObject projectResponseObject = this.httpClient.post(this.url + "/projects", request, new HttpRequestConfig(), ProjectResponseObject.class);
        return ResponseObject.of(projectResponseObject.getData());
    }

    public ResponseObject<? extends Project> getProject(Long projectId) throws HttpException, HttpBadRequestException {
        ProjectResponseObject projectResponseObject = this.httpClient.get(this.url + "/projects/" + projectId, new HttpRequestConfig(), ProjectResponseObject.class);
        return ResponseObject.of(projectResponseObject.getData());
    }

    public void deleteProject(Long projectId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<? extends Project> editProject(Long projectId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        ProjectResponseObject projectResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId, request, new HttpRequestConfig(), ProjectResponseObject.class);
        return ResponseObject.of(projectResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadProjectFileFormatSettingsCustomSegmentation(Long projectId, Long fileFormatSettingsId) {
        String url = this.formUrl_projectFileFormatSettingsId_customSegmentations(projectId, fileFormatSettingsId);
        DownloadLinkResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void resetProjectFileFormatSettingsCustomSegmentation(Long projectId, Long fileFormatSettingsId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectFileFormatSettingsId_customSegmentations(projectId, fileFormatSettingsId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<FileFormatSettingsResource> listProjectFileFormatSettings(Long projectId) {
        String url = this.formUrl_projectFileFormatSettings(projectId);
        FileFormatSettingsResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(), FileFormatSettingsResponseList.class);
        return FileFormatSettingsResponseList.to(responseList);
    }

    public ResponseObject<FileFormatSettingsResource> addProjectFileFormatSettings(Long projectId, AddProjectFileFormatSettingsRequest request) {
        String url = this.formUrl_projectFileFormatSettings(projectId);
        FileFormatSettingsResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), FileFormatSettingsResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<FileFormatSettingsResource> getProjectFileFormatSettings(Long projectId, Long fileFormatSettingsId) {
        String url = this.formUrl_projectFileFormatSettingsId(projectId, fileFormatSettingsId);
        FileFormatSettingsResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), FileFormatSettingsResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteProjectFileFormatSettings(Long projectId, Long fileFormatSettingsId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectFileFormatSettingsId(projectId, fileFormatSettingsId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<FileFormatSettingsResource> editProjectFileFormatSettings(Long projectId, Long fileFormatSettingsId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectFileFormatSettingsId(projectId, fileFormatSettingsId);
        FileFormatSettingsResponseObject response = this.httpClient.patch(url, request, new HttpRequestConfig(), FileFormatSettingsResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    private String formUrl_projectFileFormatSettings(Long projectId) {
        return this.url + "/projects/" + projectId + "/file-format-settings";
    }

    private String formUrl_projectFileFormatSettingsId(Long projectId, Long fileFormatSettingsId) {
        return this.url + "/projects/" + projectId + "/file-format-settings/" + fileFormatSettingsId;
    }

    private String formUrl_projectFileFormatSettingsId_customSegmentations(Long projectId, Long fileFormatSettingsId) {
        return this.url + "/projects/" + projectId + "/file-format-settings/" + fileFormatSettingsId + "/custom-segmentations";
    }

    public ResponseList<StringsExporterSettingsResource> listProjectStringsExporterSettings(Long projectId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectStringsExporterSettings(projectId);
        StringsExporterSettingsResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(), StringsExporterSettingsResponseList.class);
        return StringsExporterSettingsResponseList.to(responseList);
    }

    public ResponseObject<StringsExporterSettingsResource> addProjectStringsExporterSettings(Long projectId, StringsExporterSettingsRequest data) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectStringsExporterSettings(projectId);
        StringsExporterSettingsResponseObject responseObject = this.httpClient.post(url, data, new HttpRequestConfig(), StringsExporterSettingsResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<StringsExporterSettingsResource> getProjectStringsExporterSettings(Long projectId, Long systemStringsExporterSettingsId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectStringsExporterSettingsId(projectId, systemStringsExporterSettingsId);
        StringsExporterSettingsResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), StringsExporterSettingsResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteProjectStringsExporterSettings(Long projectId, Long systemStringsExporterSettingsId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectStringsExporterSettingsId(projectId, systemStringsExporterSettingsId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<StringsExporterSettingsResource> editProjectStringsExporterSettings(Long projectId, Long systemStringsExporterSettingsId, StringsExporterSettingsRequest request) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_projectStringsExporterSettingsId(projectId, systemStringsExporterSettingsId);
        StringsExporterSettingsResponseObject responseObject = this.httpClient.patch(url, request, new HttpRequestConfig(), StringsExporterSettingsResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    private String formUrl_projectStringsExporterSettings(Long projectId) {
        return this.url + "/projects/" + projectId + "/strings-exporter-settings";
    }

    private String formUrl_projectStringsExporterSettingsId(Long projectId, Long systemStringsExporterSettingsId) {
        return this.url + "/projects/" + projectId + "/strings-exporter-settings/" + systemStringsExporterSettingsId;
    }
}

