/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.stringcorrections;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.stringcorrections.model.AddCorrectionRequest;
import com.crowdin.client.stringcorrections.model.Correction;
import com.crowdin.client.stringcorrections.model.CorrectionResponseList;
import com.crowdin.client.stringcorrections.model.CorrectionResponseObject;
import com.crowdin.client.stringcorrections.model.ListCorrectionsQueryParams;
import java.util.Map;
import java.util.Optional;

public class StringCorrectionsApi
extends CrowdinApi {
    public StringCorrectionsApi(Credentials credentials) {
        super(credentials);
    }

    public StringCorrectionsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Correction> listCorrections(Long projectId, ListCorrectionsQueryParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.of(params.getStringId()), "orderBy", Optional.ofNullable(params.getOrderBy()), "denormalizePlaceholders", Optional.ofNullable(params.getDenormalizePlaceholders()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        CorrectionResponseList response = this.httpClient.get(this.url + "/projects/" + projectId + "/corrections", new HttpRequestConfig(queryParams), CorrectionResponseList.class);
        return CorrectionResponseList.to(response);
    }

    public ResponseObject<Correction> addCorrection(Long projectId, AddCorrectionRequest request) throws HttpException, HttpBadRequestException {
        CorrectionResponseObject response = this.httpClient.post(this.url + "/projects/" + projectId + "/corrections", request, new HttpRequestConfig(), CorrectionResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<Correction> getCorrection(Long projectId, Long correctionId) throws HttpException, HttpBadRequestException {
        CorrectionResponseObject response = this.httpClient.get(this.url + "/projects/" + projectId + "/corrections/" + correctionId, new HttpRequestConfig(), CorrectionResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteCorrections(Long projectId, Long stringId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Long>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.of(stringId));
        this.httpClient.delete(this.url + "/projects/" + projectId + "/corrections", new HttpRequestConfig(queryParams), Void.class);
    }

    public ResponseObject<Correction> restoreCorrection(Long projectId, Long correctionId) throws HttpException, HttpBadRequestException {
        CorrectionResponseObject response = this.httpClient.put(this.url + "/projects/" + projectId + "/corrections/" + correctionId, null, new HttpRequestConfig(), CorrectionResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteCorrection(Long projectId, Long correctionId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/corrections/" + correctionId, new HttpRequestConfig(), Void.class);
    }
}

