/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.tasks;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.BooleanInt;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.tasks.model.AddTaskRequest;
import com.crowdin.client.tasks.model.AddTaskSettingsTemplateRequest;
import com.crowdin.client.tasks.model.Status;
import com.crowdin.client.tasks.model.Task;
import com.crowdin.client.tasks.model.TaskResponseList;
import com.crowdin.client.tasks.model.TaskResponseObject;
import com.crowdin.client.tasks.model.TaskSettingsTemplate;
import com.crowdin.client.tasks.model.TaskSettingsTemplateResponseList;
import com.crowdin.client.tasks.model.TaskSettingsTemplateResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TasksApi
extends CrowdinApi {
    public TasksApi(Credentials credentials) {
        super(credentials);
    }

    public TasksApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Task> listTasks(Long projectId, Integer limit, Integer offset, Status status, Integer assigneeId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("status", Optional.ofNullable(status), "assigneeId", Optional.ofNullable(assigneeId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        TaskResponseList taskResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/tasks", new HttpRequestConfig(queryParams), TaskResponseList.class);
        return TaskResponseList.to(taskResponseList);
    }

    public ResponseObject<Task> addTask(Long projectId, AddTaskRequest request) throws HttpException, HttpBadRequestException {
        TaskResponseObject taskResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/tasks", request, new HttpRequestConfig(), TaskResponseObject.class);
        return ResponseObject.of(taskResponseObject.getData());
    }

    public ResponseObject<DownloadLink> exportTaskStrings(Long projectId, Long taskId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/tasks/" + taskId + "/exports", null, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseObject<Task> getTask(Long projectId, Long taskId) throws HttpException, HttpBadRequestException {
        TaskResponseObject taskResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/tasks/" + taskId, new HttpRequestConfig(), TaskResponseObject.class);
        return ResponseObject.of(taskResponseObject.getData());
    }

    public void deleteTask(Long projectId, Long taskId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/tasks/" + taskId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Task> editTask(Long projectId, Long taskId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        TaskResponseObject taskResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/tasks/" + taskId, request, new HttpRequestConfig(), TaskResponseObject.class);
        return ResponseObject.of(taskResponseObject.getData());
    }

    public ResponseList<Task> listUserTasks(Integer limit, Integer offset, Status status, BooleanInt isArchived) throws HttpException, HttpBadRequestException {
        Map<String, Optional<BooleanInt>> queryParams = HttpRequestConfig.buildUrlParams("status", Optional.ofNullable(status), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset), "isArchived", Optional.ofNullable(isArchived));
        TaskResponseList taskResponseList = this.httpClient.get(this.url + "/user/tasks", new HttpRequestConfig(queryParams), TaskResponseList.class);
        return TaskResponseList.to(taskResponseList);
    }

    public ResponseObject<Task> editTaskArchivedStatus(Long taskId, Long projectId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Long>> queryParams = HttpRequestConfig.buildUrlParams("projectId", Optional.ofNullable(projectId));
        TaskResponseObject taskResponseObject = this.httpClient.patch(this.url + "/user/tasks/" + taskId, request, new HttpRequestConfig(queryParams), TaskResponseObject.class);
        return ResponseObject.of(taskResponseObject.getData());
    }

    public ResponseList<TaskSettingsTemplate> listTaskSettingsTemplates(Long projectId, Integer limit, Integer offset) {
        String url = this.formUrl_taskSettingsTemplates(projectId);
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        TaskSettingsTemplateResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(queryParams), TaskSettingsTemplateResponseList.class);
        return TaskSettingsTemplateResponseList.to(responseList);
    }

    public ResponseObject<TaskSettingsTemplate> addTaskSettingsTemplate(Long projectId, AddTaskSettingsTemplateRequest request) {
        String url = this.formUrl_taskSettingsTemplates(projectId);
        TaskSettingsTemplateResponseObject responseObject = this.httpClient.post(url, request, new HttpRequestConfig(), TaskSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<TaskSettingsTemplate> getTaskSettingsTemplate(Long projectId, Long taskSettingsTemplateId) {
        String url = this.formUrl_taskSettingsTemplateId(projectId, taskSettingsTemplateId);
        TaskSettingsTemplateResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), TaskSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteTaskSettingsTemplate(Long projectId, Long taskSettingsTemplateId) {
        String url = this.formUrl_taskSettingsTemplateId(projectId, taskSettingsTemplateId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<TaskSettingsTemplate> editTaskSettingsTemplate(Long projectId, Long taskSettingsTemplateId, List<PatchRequest> request) {
        String url = this.formUrl_taskSettingsTemplateId(projectId, taskSettingsTemplateId);
        TaskSettingsTemplateResponseObject responseObject = this.httpClient.patch(url, request, new HttpRequestConfig(), TaskSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    private String formUrl_taskSettingsTemplates(Long projectId) {
        return this.url + "/projects/" + projectId + "/tasks/settings-templates";
    }

    private String formUrl_taskSettingsTemplateId(Long projectId, Long taskSettingsTemplateId) {
        return this.url + "/projects/" + projectId + "/tasks/settings-templates/" + taskSettingsTemplateId;
    }
}

