/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.teams;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.teams.model.AddTeamMembersRequest;
import com.crowdin.client.teams.model.AddTeamMembersResponse;
import com.crowdin.client.teams.model.AddTeamMembersResponseInternal;
import com.crowdin.client.teams.model.AddTeamRequest;
import com.crowdin.client.teams.model.AddTeamToProjectRequest;
import com.crowdin.client.teams.model.GroupTeam;
import com.crowdin.client.teams.model.GroupTeamResponseList;
import com.crowdin.client.teams.model.GroupTeamResponseObject;
import com.crowdin.client.teams.model.ProjectTeamResources;
import com.crowdin.client.teams.model.Team;
import com.crowdin.client.teams.model.TeamMember;
import com.crowdin.client.teams.model.TeamMemberResponseList;
import com.crowdin.client.teams.model.TeamResponseList;
import com.crowdin.client.teams.model.TeamResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TeamsApi
extends CrowdinApi {
    public TeamsApi(Credentials credentials) {
        super(credentials);
    }

    public TeamsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<GroupTeam> listGroupTeams(Long groupId, String orderBy) throws HttpException, HttpBadRequestException {
        Map<String, Optional<String>> queryParams = HttpRequestConfig.buildUrlParams("orderBy", Optional.ofNullable(orderBy));
        GroupTeamResponseList response = this.httpClient.get(this.url + "/groups/" + groupId + "/teams", new HttpRequestConfig(queryParams), GroupTeamResponseList.class);
        return GroupTeamResponseList.to(response);
    }

    public ResponseList<GroupTeam> updateGroupTeams(Long groupId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        GroupTeamResponseList response = this.httpClient.patch(this.url + "/groups/" + groupId + "/teams", request, new HttpRequestConfig(), GroupTeamResponseList.class);
        return GroupTeamResponseList.to(response);
    }

    public ResponseObject<GroupTeam> getGroupTeam(Long groupId, Long teamId) throws HttpException, HttpBadRequestException {
        GroupTeamResponseObject response = this.httpClient.get(this.url + "/groups/" + groupId + "/teams/" + teamId, new HttpRequestConfig(), GroupTeamResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ProjectTeamResources addTeamToProject(Long projectId, AddTeamToProjectRequest request) throws HttpException, HttpBadRequestException {
        return this.httpClient.post(this.url + "/projects/" + projectId + "/teams", request, new HttpRequestConfig(), ProjectTeamResources.class);
    }

    public ResponseList<Team> listTeams(Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        TeamResponseList teamResponseList = this.httpClient.get(this.url + "/teams", new HttpRequestConfig(queryParams), TeamResponseList.class);
        return TeamResponseList.to(teamResponseList);
    }

    public ResponseObject<Team> addTeam(AddTeamRequest request) throws HttpException, HttpBadRequestException {
        TeamResponseObject teamResponseObject = this.httpClient.post(this.url + "/teams", request, new HttpRequestConfig(), TeamResponseObject.class);
        return ResponseObject.of(teamResponseObject.getData());
    }

    public ResponseObject<Team> getTeam(Long teamId) throws HttpException, HttpBadRequestException {
        TeamResponseObject teamResponseObject = this.httpClient.get(this.url + "/teams/" + teamId, new HttpRequestConfig(), TeamResponseObject.class);
        return ResponseObject.of(teamResponseObject.getData());
    }

    public void deleteTeam(Long teamId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/teams/" + teamId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Team> editTeam(Long teamId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        TeamResponseObject teamResponseObject = this.httpClient.patch(this.url + "/teams/" + teamId, request, new HttpRequestConfig(), TeamResponseObject.class);
        return ResponseObject.of(teamResponseObject.getData());
    }

    public ResponseList<TeamMember> listTeamMembers(Long teamId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        TeamMemberResponseList teamMemberResponseList = this.httpClient.get(this.url + "/teams/" + teamId + "/members", new HttpRequestConfig(queryParams), TeamMemberResponseList.class);
        return TeamMemberResponseList.to(teamMemberResponseList);
    }

    public AddTeamMembersResponse addTeamMembers(Long teamId, AddTeamMembersRequest request) throws HttpException, HttpBadRequestException {
        AddTeamMembersResponseInternal addTeamMembersResponseInternal = this.httpClient.post(this.url + "/teams/" + teamId + "/members", request, new HttpRequestConfig(), AddTeamMembersResponseInternal.class);
        return AddTeamMembersResponseInternal.to(addTeamMembersResponseInternal);
    }

    public void deleteAllTeamMembers(Long teamId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/teams/" + teamId + "/members", new HttpRequestConfig(), Void.class);
    }

    public void deleteTeamMember(Long teamId, Long memberId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/teams/" + teamId + "/members/" + memberId, new HttpRequestConfig(), Void.class);
    }
}

