/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.webhooks;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.webhooks.model.AddOrganizationWebhookRequest;
import com.crowdin.client.webhooks.model.OrganizationWebhook;
import com.crowdin.client.webhooks.model.OrganizationWebhookResponseList;
import com.crowdin.client.webhooks.model.OrganizationWebhookResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrganizationWebhooksApi
extends CrowdinApi {
    private final String baseUrl = "/webhooks";

    public OrganizationWebhooksApi(Credentials credentials) {
        super(credentials);
    }

    public OrganizationWebhooksApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<OrganizationWebhook> listWebhooks(Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        OrganizationWebhookResponseList responseList = this.httpClient.get("/webhooks", new HttpRequestConfig(queryParams), OrganizationWebhookResponseList.class);
        return OrganizationWebhookResponseList.to(responseList);
    }

    public ResponseObject<OrganizationWebhook> addWebhook(AddOrganizationWebhookRequest request) throws HttpException, HttpBadRequestException {
        OrganizationWebhookResponseObject responseObject = this.httpClient.post("/webhooks", request, new HttpRequestConfig(), OrganizationWebhookResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<OrganizationWebhook> getWebhook(Long organizationWebhookId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_webhookId(organizationWebhookId);
        OrganizationWebhookResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), OrganizationWebhookResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteWebhook(Long organizationWebhookId) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_webhookId(organizationWebhookId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<OrganizationWebhook> editWebhook(Long organizationWebhookId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        String url = this.formUrl_webhookId(organizationWebhookId);
        OrganizationWebhookResponseObject responseObject = this.httpClient.patch(url, request, new HttpRequestConfig(), OrganizationWebhookResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    private String formUrl_webhookId(Long organizationWebhookId) {
        return this.url + "/webhooks/" + organizationWebhookId;
    }
}

