/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.webhooks;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.webhooks.model.AddWebhookRequest;
import com.crowdin.client.webhooks.model.Webhook;
import com.crowdin.client.webhooks.model.WebhookResponseList;
import com.crowdin.client.webhooks.model.WebhookResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class WebhooksApi
extends CrowdinApi {
    public WebhooksApi(Credentials credentials) {
        super(credentials);
    }

    public WebhooksApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Webhook> listWebhooks(Long projectId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        WebhookResponseList webhookResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/webhooks", new HttpRequestConfig(queryParams), WebhookResponseList.class);
        return WebhookResponseList.to(webhookResponseList);
    }

    public ResponseObject<Webhook> addWebhook(Long projectId, AddWebhookRequest request) throws HttpException, HttpBadRequestException {
        WebhookResponseObject webhookResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/webhooks", request, new HttpRequestConfig(), WebhookResponseObject.class);
        return ResponseObject.of(webhookResponseObject.getData());
    }

    public ResponseObject<Webhook> getWebhook(Long projectId, Long webhookId) throws HttpException, HttpBadRequestException {
        WebhookResponseObject webhookResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/webhooks/" + webhookId, new HttpRequestConfig(), WebhookResponseObject.class);
        return ResponseObject.of(webhookResponseObject.getData());
    }

    public void deleteWebhook(Long projectId, Long webhookId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/webhooks/" + webhookId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Webhook> editWebhook(Long projectId, Long webhookId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        WebhookResponseObject webhookResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/webhooks/" + webhookId, request, new HttpRequestConfig(), WebhookResponseObject.class);
        return ResponseObject.of(webhookResponseObject.getData());
    }
}

