/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.client.ClientComment;
import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.client.ClientLabel;
import com.crowdin.cli.client.ClientScreenshot;
import com.crowdin.cli.client.ClientTask;
import com.crowdin.cli.client.ClientTm;
import com.crowdin.cli.client.CrowdinClientBundle;
import com.crowdin.cli.client.CrowdinClientComment;
import com.crowdin.cli.client.CrowdinClientDistribution;
import com.crowdin.cli.client.CrowdinClientGlossary;
import com.crowdin.cli.client.CrowdinClientLabel;
import com.crowdin.cli.client.CrowdinClientScreenshot;
import com.crowdin.cli.client.CrowdinClientTask;
import com.crowdin.cli.client.CrowdinClientTm;
import com.crowdin.cli.client.CrowdinProjectClient;
import com.crowdin.cli.client.NoClient;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.Client;
import com.crowdin.client.core.http.impl.json.JacksonJsonTransformer;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public final class Clients {
    private static final int TIMEOUT = 1800000;

    private Clients() {
    }

    public static NoClient noClient() {
        return new NoClient(){};
    }

    public static ClientGlossary getClientGlossary(String apiToken, String baseUrl) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientGlossary(client);
    }

    public static ClientTm getClientTm(String apiToken, String baseUrl) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientTm(client);
    }

    public static ClientTask getClientTask(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientTask(client, projectId);
    }

    public static ClientComment getClientComment(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientComment(client, projectId);
    }

    public static ClientDistribution getClientDistribution(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientDistribution(client, projectId);
    }

    public static ClientBundle getClientBundle(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientBundle(client, projectId);
    }

    public static ClientScreenshot getClientScreenshot(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientScreenshot(client, projectId);
    }

    public static ClientLabel getClientLabel(String apiToken, String baseUrl, String projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinClientLabel(client, projectId);
    }

    public static ProjectClient getProjectClient(String apiToken, String baseUrl, long projectId) {
        Client client = Clients.prepareClient(apiToken, baseUrl);
        return new CrowdinProjectClient(client, projectId);
    }

    private static Client prepareClient(String apiToken, String baseUrl) {
        boolean isTesting = PropertiesBeanUtils.isUrlForTesting(baseUrl);
        String organization = PropertiesBeanUtils.getOrganization(baseUrl);
        Credentials credentials = isTesting ? new Credentials(apiToken, organization, baseUrl) : new Credentials(apiToken, organization);
        ClientConfig clientConfig = ClientConfig.builder().jsonTransformer(new JacksonJsonTransformer()).userAgent(Utils.buildUserAgent()).httpTimeoutMs(1800000).build();
        Utils.proxyHost().map(pair -> new ClientConfig.Host((String)pair.getKey(), (Integer)pair.getValue())).ifPresent(proxy -> {
            clientConfig.setProxy((ClientConfig.Host)proxy);
            System.setProperty("https.proxyHost", proxy.getHost());
            System.setProperty("https.proxyPort", String.valueOf(proxy.getPort()));
        });
        Utils.proxyCredentials().map(pair -> new ClientConfig.UsernamePasswordCredentials((String)pair.getKey(), (String)pair.getValue())).ifPresent(proxyCreds -> {
            clientConfig.setProxyCreds((ClientConfig.UsernamePasswordCredentials)proxyCreds);
            if (proxyCreds.getUsername() != null && proxyCreds.getPassword() != null) {
                Authenticator.setDefault(new Authenticator((ClientConfig.UsernamePasswordCredentials)proxyCreds){
                    final /* synthetic */ ClientConfig.UsernamePasswordCredentials val$proxyCreds;
                    {
                        this.val$proxyCreds = usernamePasswordCredentials;
                    }

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                            return new PasswordAuthentication(this.val$proxyCreds.getUsername(), this.val$proxyCreds.getPassword().toCharArray());
                        }
                        return null;
                    }
                });
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            }
        });
        return new Client(credentials, clientConfig);
    }
}

