/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.cli.client.RepeatException;
import com.crowdin.cli.client.ResponseException;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.Client;
import com.crowdin.client.bundles.model.AddBundleRequest;
import com.crowdin.client.bundles.model.Bundle;
import com.crowdin.client.bundles.model.BundleExport;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;

public class CrowdinClientBundle
extends CrowdinClientCore
implements ClientBundle {
    private final Client client;
    private final String projectId;

    public CrowdinClientBundle(Client client, String projectId) {
        this.client = client;
        this.projectId = projectId;
    }

    @Override
    public List<Bundle> listBundle() {
        return CrowdinClientBundle.executeRequestFullList((limit, offset) -> this.client.getBundlesApi().listBundles(Long.valueOf(this.projectId)));
    }

    @Override
    public Bundle addBundle(AddBundleRequest addBundleRequest) {
        return CrowdinClientBundle.executeRequest(() -> this.client.getBundlesApi().addBundle(Long.valueOf(this.projectId), addBundleRequest).getData());
    }

    @Override
    public Bundle getBundle(Long bundleId) {
        return (Bundle)CrowdinClientBundle.executeRequest(() -> this.client.getBundlesApi().getBundle(Long.valueOf(this.projectId), bundleId)).getData();
    }

    @Override
    public void deleteBundle(Long bundleId) {
        CrowdinClientBundle.executeRequest(() -> this.client.getBundlesApi().deleteBundle(Long.valueOf(this.projectId), bundleId));
    }

    @Override
    public URL downloadBundle(Long id, String exportId) {
        return this.url(CrowdinClientBundle.executeRequest(() -> this.client.getBundlesApi().downloadBundle(Long.valueOf(this.projectId), id, exportId).getData()));
    }

    @Override
    public BundleExport startExportingBundle(Long id) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandler = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> message.contains("Another export is currently in progress. Please wait until it's finished."), new RepeatException("Another export is currently in progress. Please wait until it's finished."));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
            }
        };
        return CrowdinClientBundle.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorHandler, () -> this.client.getBundlesApi().exportBundle(Long.valueOf(this.projectId), id).getData(), 3, 3000L);
    }

    @Override
    public BundleExport checkExportingBundle(Long id, String exportId) {
        return CrowdinClientBundle.executeRequest(() -> this.client.getBundlesApi().checkBundleExportStatus(Long.valueOf(this.projectId), id, exportId).getData());
    }

    @Override
    public String getBundleUrl(Long bundleId) {
        return this.getBundle(bundleId).getWebUrl();
    }
}

