/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.client.Client;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.distributions.model.AddDistributionRequest;
import com.crowdin.client.distributions.model.AddDistributionStringsBasedRequest;
import com.crowdin.client.distributions.model.Distribution;
import com.crowdin.client.distributions.model.DistributionRelease;
import com.crowdin.client.distributions.model.DistributionStringsBasedRelease;
import java.util.List;

public class CrowdinClientDistribution
extends CrowdinClientCore
implements ClientDistribution {
    private final Client client;
    private final String projectId;

    public CrowdinClientDistribution(Client client, String projectId) {
        this.client = client;
        this.projectId = projectId;
    }

    @Override
    public List<Distribution> listDistribution() {
        return CrowdinClientDistribution.executeRequestFullList((limit, offset) -> this.client.getDistributionsApi().listDistributions(Long.valueOf(this.projectId), (Integer)limit, (Integer)offset));
    }

    @Override
    public Distribution addDistribution(AddDistributionRequest distributionRequest) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().addDistribution(Long.valueOf(this.projectId), distributionRequest).getData());
    }

    @Override
    public Distribution addDistributionStringsBased(AddDistributionStringsBasedRequest distributionRequest) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().addDistributionStringsBased(Long.valueOf(this.projectId), distributionRequest).getData());
    }

    @Override
    public DistributionRelease release(String hash) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().createDistributionRelease(Long.valueOf(this.projectId), hash).getData());
    }

    @Override
    public DistributionStringsBasedRelease releaseStringsBased(String hash) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().createDistributionStringsBasedRelease(Long.valueOf(this.projectId), hash).getData());
    }

    @Override
    public DistributionRelease getDistributionRelease(String hash) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().getDistributionRelease(Long.valueOf(this.projectId), hash).getData());
    }

    @Override
    public DistributionStringsBasedRelease getDistributionStringsBasedRelease(String hash) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().getDistributionStringsBasedRelease(Long.valueOf(this.projectId), hash).getData());
    }

    @Override
    public Distribution editDistribution(String hash, List<PatchRequest> request) {
        return CrowdinClientDistribution.executeRequest(() -> this.client.getDistributionsApi().editDistribution(Long.valueOf(this.projectId), hash, request).getData());
    }
}

