/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.client.Client;
import com.crowdin.client.glossaries.model.AddGlossaryRequest;
import com.crowdin.client.glossaries.model.ExportGlossaryRequest;
import com.crowdin.client.glossaries.model.Glossary;
import com.crowdin.client.glossaries.model.GlossaryExportStatus;
import com.crowdin.client.glossaries.model.GlossaryImportStatus;
import com.crowdin.client.glossaries.model.ImportGlossaryRequest;
import com.crowdin.client.glossaries.model.Term;
import com.crowdin.client.storage.model.Storage;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiPredicate;

public class CrowdinClientGlossary
extends CrowdinClientCore
implements ClientGlossary {
    private final Client client;

    public CrowdinClientGlossary(Client client) {
        this.client = client;
    }

    @Override
    public List<Glossary> listGlossaries() {
        return CrowdinClientGlossary.executeRequestFullList((limit, offset) -> this.client.getGlossariesApi().listGlossaries(null, (Integer)limit, (Integer)offset));
    }

    @Override
    public Glossary getGlossary(Long glossaryId) {
        return CrowdinClientGlossary.executeRequest(() -> this.client.getGlossariesApi().getGlossary(glossaryId).getData());
    }

    @Override
    public Glossary addGlossary(AddGlossaryRequest request) {
        return CrowdinClientGlossary.executeRequest(() -> this.client.getGlossariesApi().addGlossary(request).getData());
    }

    @Override
    public GlossaryImportStatus importGlossary(Long glossaryId, ImportGlossaryRequest request) {
        LinkedHashMap<BiPredicate<String, String>, RuntimeException> errorHandler = new LinkedHashMap<BiPredicate<String, String>, RuntimeException>(){
            {
                this.put((code, message) -> code.equals("409") && message.contains("Another import is currently in progress"), new RuntimeException("Another import is currently in progress. Please wait until it's finished."));
            }
        };
        return CrowdinClientGlossary.executeRequest(errorHandler, () -> this.client.getGlossariesApi().importGlossary(glossaryId, request).getData());
    }

    @Override
    public GlossaryExportStatus startExportingGlossary(Long glossaryId, ExportGlossaryRequest request) {
        return CrowdinClientGlossary.executeRequest(() -> this.client.getGlossariesApi().exportGlossary(glossaryId, request).getData());
    }

    @Override
    public GlossaryExportStatus checkExportingGlossary(Long glossaryId, String exportId) {
        return CrowdinClientGlossary.executeRequest(() -> this.client.getGlossariesApi().checkGlossaryExportStatus(glossaryId, exportId).getData());
    }

    @Override
    public URL downloadGlossary(Long glossaryId, String exportId) {
        return this.url(CrowdinClientGlossary.executeRequest(() -> this.client.getGlossariesApi().downloadGlossary(glossaryId, exportId).getData()));
    }

    @Override
    public List<Term> listTerms(Long glossaryId) {
        return CrowdinClientGlossary.executeRequestFullList((limit, offset) -> this.client.getGlossariesApi().listTerms(glossaryId, null, null, null, null, (Integer)limit, (Integer)offset));
    }

    @Override
    public Long uploadStorage(String fileName, InputStream content) {
        Storage storage = CrowdinClientGlossary.executeRequest(() -> this.client.getStorageApi().addStorage(fileName, content).getData());
        return storage.getId();
    }
}

