/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.AutoTagInProgressException;
import com.crowdin.cli.client.ClientScreenshot;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.cli.client.ResponseException;
import com.crowdin.client.Client;
import com.crowdin.client.screenshots.model.AddScreenshotRequest;
import com.crowdin.client.screenshots.model.AutoTagReplaceTagsRequest;
import com.crowdin.client.screenshots.model.ListScreenshotsParams;
import com.crowdin.client.screenshots.model.Screenshot;
import com.crowdin.client.screenshots.model.UpdateScreenshotRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiPredicate;

public class CrowdinClientScreenshot
extends CrowdinClientCore
implements ClientScreenshot {
    private final Client client;
    private final String projectId;

    @Override
    public List<Screenshot> listScreenshots(Long stringId) {
        return CrowdinClientScreenshot.executeRequestFullList((limit, offset) -> this.client.getScreenshotsApi().listScreenshots(Long.parseLong(this.projectId), stringId, (Integer)limit, (Integer)offset));
    }

    @Override
    public List<Screenshot> listScreenshotsByName(String fileName) {
        return CrowdinClientScreenshot.executeRequestFullList((limit, offset) -> {
            ListScreenshotsParams params = new ListScreenshotsParams();
            params.setOffset((Integer)offset);
            params.setLimit((Integer)limit);
            params.setSearch(fileName);
            return this.client.getScreenshotsApi().listScreenshots(Long.parseLong(this.projectId), params);
        });
    }

    @Override
    public Screenshot getScreenshot(Long id) {
        return CrowdinClientScreenshot.executeRequest(() -> this.client.getScreenshotsApi().getScreenshot(Long.parseLong(this.projectId), id).getData());
    }

    @Override
    public Screenshot uploadScreenshot(AddScreenshotRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandler = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> code.equals("409") && message.contains("Auto tag is currently in progress"), new AutoTagInProgressException());
            }
        };
        return CrowdinClientScreenshot.executeRequest(errorHandler, () -> this.client.getScreenshotsApi().addScreenshot(Long.parseLong(this.projectId), request).getData());
    }

    @Override
    public Screenshot updateScreenshot(Long screenshotId, UpdateScreenshotRequest request) {
        return CrowdinClientScreenshot.executeRequest(() -> this.client.getScreenshotsApi().updateScreenshot(Long.parseLong(this.projectId), screenshotId, request).getData());
    }

    @Override
    public void deleteScreenshot(Long id) {
        CrowdinClientScreenshot.executeRequest(() -> {
            this.client.getScreenshotsApi().deleteScreenshot(Long.parseLong(this.projectId), id);
            return null;
        });
    }

    @Override
    public void replaceTags(Long screenshotId, AutoTagReplaceTagsRequest request) {
        CrowdinClientScreenshot.executeRequest(() -> {
            this.client.getScreenshotsApi().replaceTags(Long.parseLong(this.projectId), screenshotId, request);
            return null;
        });
    }

    public CrowdinClientScreenshot(Client client, String projectId) {
        this.client = client;
        this.projectId = projectId;
    }
}

