/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.cli.client.CrowdinProject;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.CrowdinProjectInfo;
import com.crowdin.cli.client.EmptyFileException;
import com.crowdin.cli.client.ExistsResponseException;
import com.crowdin.cli.client.FileInUpdateException;
import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.client.RepeatException;
import com.crowdin.cli.client.ResponseException;
import com.crowdin.cli.client.WaitResponseException;
import com.crowdin.cli.client.WrongLanguageException;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.Client;
import com.crowdin.client.applications.installations.model.ApplicationInstallation;
import com.crowdin.client.applications.installations.model.InstallApplicationRequest;
import com.crowdin.client.branches.model.BranchCloneStatus;
import com.crowdin.client.branches.model.BranchMergeStatus;
import com.crowdin.client.branches.model.BranchMergeSummary;
import com.crowdin.client.branches.model.CloneBranchRequest;
import com.crowdin.client.branches.model.ClonedBranch;
import com.crowdin.client.branches.model.MergeBranchRequest;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.labels.model.AddLabelRequest;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.machinetranslationengines.model.MachineTranslation;
import com.crowdin.client.projectsgroups.model.AddProjectRequest;
import com.crowdin.client.projectsgroups.model.Project;
import com.crowdin.client.projectsgroups.model.ProjectSettings;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.AddBranchRequest;
import com.crowdin.client.sourcefiles.model.AddDirectoryRequest;
import com.crowdin.client.sourcefiles.model.AddFileRequest;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.BuildReviewedSourceFilesRequest;
import com.crowdin.client.sourcefiles.model.Directory;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.ReviewedStringsBuild;
import com.crowdin.client.sourcefiles.model.UpdateFileRequest;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.ListSourceStringsParams;
import com.crowdin.client.sourcestrings.model.SourceString;
import com.crowdin.client.sourcestrings.model.UploadStringsProgress;
import com.crowdin.client.sourcestrings.model.UploadStringsRequest;
import com.crowdin.client.storage.model.Storage;
import com.crowdin.client.stringcomments.model.AddStringCommentRequest;
import com.crowdin.client.stringcomments.model.StringComment;
import com.crowdin.client.translations.model.ApplyPreTranslationRequest;
import com.crowdin.client.translations.model.ApplyPreTranslationStringsBasedRequest;
import com.crowdin.client.translations.model.BuildProjectFileTranslationRequest;
import com.crowdin.client.translations.model.BuildProjectTranslationRequest;
import com.crowdin.client.translations.model.PreTranslationReportResponse;
import com.crowdin.client.translations.model.PreTranslationStatus;
import com.crowdin.client.translations.model.ProjectBuild;
import com.crowdin.client.translations.model.UploadTranslationsRequest;
import com.crowdin.client.translations.model.UploadTranslationsStringsRequest;
import com.crowdin.client.translationstatus.model.LanguageProgress;
import com.crowdin.client.users.model.User;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

class CrowdinProjectClient
extends CrowdinClientCore
implements ProjectClient {
    private final Client client;
    private final long projectId;

    public CrowdinProjectClient(Client client, long projectId) {
        this.client = client;
        this.projectId = projectId;
    }

    @Override
    public List<Language> listSupportedLanguages() {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getLanguagesApi().listSupportedLanguages((Integer)limit, (Integer)offset));
    }

    @Override
    public CrowdinProjectFull downloadFullProject(String branchName) {
        CrowdinProjectFull project = new CrowdinProjectFull();
        this.populateProjectWithInfo(project);
        this.populateProjectWithLangs(project);
        this.populateProjectWithStructure(project, branchName);
        return project;
    }

    @Override
    public CrowdinProject downloadProjectWithLanguages() {
        CrowdinProject project = new CrowdinProject();
        this.populateProjectWithInfo(project);
        this.populateProjectWithLangs(project);
        return project;
    }

    @Override
    public CrowdinProjectInfo downloadProjectInfo() {
        CrowdinProjectInfo project = new CrowdinProjectInfo();
        this.populateProjectWithInfo(project);
        return project;
    }

    private void populateProjectWithStructure(CrowdinProjectFull project, String branchName) {
        project.setBranches(this.listBranches());
        Optional.ofNullable(branchName).map(name -> project.findBranchByName((String)name).orElseThrow(() -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.not_found_branch")))).ifPresent(project::setBranch);
        Long branchId = Optional.ofNullable(project.getBranch()).map(Branch::getId).orElse(null);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (isStringsBasedProject) {
            return;
        }
        project.setFiles(CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getSourceFilesApi().listFiles(this.projectId, branchId, null, null, true, (Integer)limit, (Integer)offset)));
        project.setDirectories(CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getSourceFilesApi().listDirectories(this.projectId, branchId, null, null, true, (Integer)limit, (Integer)offset)));
    }

    private void populateProjectWithLangs(CrowdinProject project) {
        project.setSupportedLanguages(this.listSupportedLanguages());
    }

    private void populateProjectWithInfo(CrowdinProjectInfo project) {
        Project projectModel = this.getProject();
        project.setProjectId(projectModel.getId());
        project.setType(projectModel.getType());
        project.setSourceLanguageId(projectModel.getSourceLanguageId());
        project.setProjectLanguages(projectModel.getTargetLanguages());
        if (projectModel instanceof ProjectSettings) {
            project.setAccessLevel(CrowdinProjectInfo.Access.MANAGER);
            ProjectSettings projectSettings = (ProjectSettings)projectModel;
            if (projectSettings.getInContext() != null && projectSettings.getInContext().booleanValue()) {
                project.setInContextLanguage(projectSettings.getInContextPseudoLanguage());
            }
            if (projectSettings.getSkipUntranslatedFiles() != null && projectSettings.getSkipUntranslatedFiles().booleanValue()) {
                project.setSkipUntranslatedFiles(projectSettings.getSkipUntranslatedFiles());
            }
            project.setLanguageMapping(LanguageMapping.fromServerLanguageMapping(projectSettings.getLanguageMapping()));
        } else {
            project.setAccessLevel(CrowdinProjectInfo.Access.TRANSLATOR);
        }
    }

    private Project getProject() {
        return CrowdinProjectClient.executeRequest(() -> this.client.getProjectsGroupsApi().getProject(this.projectId).getData());
    }

    @Override
    public List<LanguageProgress> getProjectProgress(String languageId) {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getTranslationStatusApi().getProjectProgress(this.projectId, (Integer)limit, (Integer)offset, languageId));
    }

    @Override
    public List<LanguageProgress> getBranchProgress(Long branchId) {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getTranslationStatusApi().getBranchProgress(this.projectId, branchId, (Integer)limit, (Integer)offset));
    }

    @Override
    public List<LanguageProgress> getFileProgress(Long fileId) {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getTranslationStatusApi().getFileProgress(this.projectId, fileId, (Integer)limit, (Integer)offset));
    }

    @Override
    public List<LanguageProgress> getDirectoryProgress(Long directoryId) {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getTranslationStatusApi().getDirectoryProgress(this.projectId, directoryId, (Integer)limit, (Integer)offset));
    }

    @Override
    public Branch addBranch(AddBranchRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().addBranch(this.projectId, request).getData());
    }

    @Override
    public BranchCloneStatus cloneBranch(Long branchId, CloneBranchRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> StringUtils.containsAny((CharSequence)message, (CharSequence)"Name must be unique"), new ExistsResponseException());
            }
        };
        return CrowdinProjectClient.executeRequest(errorHandlers, () -> this.client.getBranchesApi().cloneBranch(this.projectId, branchId, request).getData());
    }

    @Override
    public BranchCloneStatus checkCloneBranchStatus(Long branchId, String cloneId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getBranchesApi().checkCloneBranchStatus(this.projectId, branchId, cloneId).getData());
    }

    @Override
    public ClonedBranch getClonedBranch(Long branchId, String cloneId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getBranchesApi().getClonedBranch(this.projectId, branchId, cloneId).getData());
    }

    @Override
    public BranchMergeStatus mergeBranch(Long branchId, MergeBranchRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getBranchesApi().mergeBranch(this.projectId, branchId, request).getData());
    }

    @Override
    public BranchMergeStatus checkMergeBranchStatus(Long branchId, String mergeId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getBranchesApi().checkMergeBranchStatus(this.projectId, branchId, mergeId).getData());
    }

    @Override
    public BranchMergeSummary getBranchMergeSummary(Long branchId, String mergeId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getBranchesApi().getMergeBranchSummary(this.projectId, branchId, mergeId).getData());
    }

    @Override
    public void deleteBranch(Long branchId) {
        CrowdinProjectClient.executeRequest(() -> {
            this.client.getSourceFilesApi().deleteBranch(this.projectId, branchId);
            return null;
        });
    }

    @Override
    public Branch editBranch(Long branchId, List<PatchRequest> requests) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().editBranch(this.projectId, branchId, requests).getData());
    }

    @Override
    public List<Branch> listBranches() {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getSourceFilesApi().listBranches(this.projectId, null, (Integer)limit, (Integer)offset));
    }

    @Override
    public Long uploadStorage(String fileName, InputStream content) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> StringUtils.containsAny((CharSequence)message, "streamIsEmpty", "Stream size is null. Not empty content expected"), new EmptyFileException("Not empty content expected"));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
                this.put((code, message) -> message.contains("Connection timed out"), new RepeatException("Connection timed out"));
            }
        };
        Storage storage = CrowdinProjectClient.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorHandlers, () -> this.client.getStorageApi().addStorage(fileName, content).getData(), 3, 2000L);
        return storage.getId();
    }

    @Override
    public Directory addDirectory(AddDirectoryRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> StringUtils.containsAny((CharSequence)message, "Name must be unique", "This file is currently being updated"), new ExistsResponseException());
                this.put((code, message) -> StringUtils.contains((CharSequence)message, "Already creating directory"), new WaitResponseException());
            }
        };
        return CrowdinProjectClient.executeRequest(errorHandlers, () -> this.client.getSourceFilesApi().addDirectory(this.projectId, request).getData());
    }

    @Override
    public void deleteDirectory(Long directoryId) {
        CrowdinProjectClient.executeRequest(() -> {
            this.client.getSourceFilesApi().deleteDirectory(this.projectId, directoryId);
            return null;
        });
    }

    @Override
    public void updateSource(Long sourceId, final UpdateFileRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> message.contains("File from storage with id #" + request.getStorageId() + " was not found"), new RepeatException("File not found in the storage"));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
                this.put((code, message) -> message.contains("Connection timed out"), new RepeatException("Connection timed out"));
                this.put((code, message) -> StringUtils.contains((CharSequence)message, "Invalid SRX specified"), new ResponseException("Invalid SRX file specified"));
                this.put((code, message) -> code.equals("409"), new FileInUpdateException());
            }
        };
        CrowdinProjectClient.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorHandlers, () -> this.client.getSourceFilesApi().updateOrRestoreFile(this.projectId, sourceId, request), 3, 2000L);
    }

    @Override
    public FileInfo addSource(final AddFileRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> message.contains("File from storage with id #" + request.getStorageId() + " was not found"), new RepeatException("File not found in the storage"));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
                this.put((code, message) -> message.contains("Connection timed out"), new RepeatException("Connection timed out"));
                this.put((code, message) -> StringUtils.contains((CharSequence)message, "Name must be unique"), new ExistsResponseException());
                this.put((code, message) -> StringUtils.contains((CharSequence)message, "Invalid SRX specified"), new ResponseException("Invalid SRX file specified"));
                this.put((code, message) -> StringUtils.containsAny((CharSequence)message, "isEmpty", "Value is required and can't be empty"), new EmptyFileException("Value is required and can't be empty"));
            }
        };
        return CrowdinProjectClient.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorHandlers, () -> this.client.getSourceFilesApi().addFile(this.projectId, request).getData(), 3, 2000L);
    }

    @Override
    public UploadStringsProgress addSourceStringsBased(UploadStringsRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().uploadStrings(this.projectId, request).getData());
    }

    @Override
    public UploadStringsProgress getUploadStringsStatus(String uploadId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().uploadStringsStatus(this.projectId, uploadId).getData());
    }

    @Override
    public void editSource(Long fileId, List<PatchRequest> request) {
        CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().editFile(this.projectId, fileId, request));
    }

    @Override
    public void deleteSource(Long fileId) {
        CrowdinProjectClient.executeRequest(() -> {
            this.client.getSourceFilesApi().deleteFile(this.projectId, fileId);
            return null;
        });
    }

    @Override
    public void uploadTranslations(String languageId, final UploadTranslationsRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorhandlers = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> code.equals("0") && message.equals("File is not allowed for the language specified"), new WrongLanguageException());
                this.put((code, message) -> message.contains("File from storage with id #" + request.getStorageId() + " was not found"), new RepeatException("File not found in the storage"));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
                this.put((code, message) -> message.contains("Connection timed out"), new RepeatException("Connection timed out"));
            }
        };
        CrowdinProjectClient.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorhandlers, () -> this.client.getTranslationsApi().uploadTranslations(this.projectId, languageId, request), 3, 2000L);
    }

    @Override
    public void uploadTranslationStringsBased(String languageId, UploadTranslationsStringsRequest request) {
        CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().uploadTranslationStringsBased(this.projectId, languageId, request));
    }

    @Override
    public ProjectBuild startBuildingTranslation(BuildProjectTranslationRequest request) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandler = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> code.equals("409") && message.contains("Another build is currently in progress"), new RepeatException("Another build is currently in progress"));
                this.put((code, message) -> Utils.isServerErrorCode(code), new RepeatException("Server Error"));
                this.put((code, message) -> message.contains("Request aborted"), new RepeatException("Request aborted"));
                this.put((code, message) -> message.contains("Connection reset"), new RepeatException("Connection reset"));
            }
        };
        return CrowdinProjectClient.executeRequestWithPossibleRetries((Map<BiPredicate<String, String>, ResponseException>)errorHandler, () -> this.client.getTranslationsApi().buildProjectTranslation(this.projectId, request).getData(), 3, 6000L);
    }

    @Override
    public ProjectBuild checkBuildingTranslation(Long buildId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().checkBuildStatus(this.projectId, buildId).getData());
    }

    @Override
    public URL buildProjectFileTranslation(Long fileId, BuildProjectFileTranslationRequest request) {
        return this.url(CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().buildProjectFileTranslation(this.projectId, fileId, null, request).getData()));
    }

    @Override
    public URL downloadBuild(Long buildId) {
        return this.url(CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().downloadProjectTranslations(this.projectId, buildId).getData()));
    }

    @Override
    public ReviewedStringsBuild startBuildingReviewedSources(BuildReviewedSourceFilesRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().buildReviewedSourceFiles(this.projectId, request).getData());
    }

    @Override
    public ReviewedStringsBuild checkBuildingReviewedSources(Long buildId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().checkReviewedSourceFilesBuildStatus(this.projectId, buildId).getData());
    }

    @Override
    public URL downloadReviewedSourcesBuild(Long buildId) {
        return this.url(CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().downloadReviewedSourceFiles(this.projectId, buildId).getData()));
    }

    @Override
    public SourceString addSourceString(AddSourceStringRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().addSourceString(this.projectId, request).getData());
    }

    @Override
    public SourceString addSourcePluralString(AddSourcePluralStringRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().addSourcePluralString(this.projectId, request).getData());
    }

    @Override
    public SourceString addSourceStringStringsBased(AddSourceStringStringsBasedRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().addSourceStringStringsBased(this.projectId, request).getData());
    }

    @Override
    public SourceString addSourcePluralStringStringsBased(AddSourcePluralStringStringsBasedRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().addSourcePluralStringStringsBased(this.projectId, request).getData());
    }

    @Override
    public List<SourceString> listSourceString(Long fileId, Long branchId, String labelIds, String filter, String croql, Long directory, String scope) {
        ListSourceStringsParams.ListSourceStringsParamsBuilder builder = ListSourceStringsParams.builder().fileId(fileId).branchId(branchId).labelIds(labelIds).filter(filter).croql(croql).directoryId(directory).scope(scope);
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getSourceStringsApi().listSourceStrings(this.projectId, builder.limit((Integer)limit).offset((Integer)offset).build()));
    }

    @Override
    public void deleteSourceString(Long sourceId) {
        CrowdinProjectClient.executeRequest(() -> {
            this.client.getSourceStringsApi().deleteSourceString(this.projectId, sourceId);
            return true;
        });
    }

    @Override
    public StringComment commentString(AddStringCommentRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getStringCommentsApi().addStringComment(this.projectId, request).getData());
    }

    @Override
    public SourceString editSourceString(Long sourceId, List<PatchRequest> requests) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getSourceStringsApi().editSourceString(this.projectId, sourceId, requests).getData());
    }

    @Override
    public List<Label> listLabels() {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getLabelsApi().listLabels(this.projectId, (Integer)limit, (Integer)offset, null));
    }

    @Override
    public Label addLabel(AddLabelRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getLabelsApi().addLabel(this.projectId, request).getData());
    }

    @Override
    public URL downloadFile(Long fileId) {
        return this.url(CrowdinProjectClient.executeRequest(() -> this.client.getSourceFilesApi().downloadFile(this.projectId, fileId).getData()));
    }

    @Override
    public PreTranslationStatus startPreTranslation(ApplyPreTranslationRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().applyPreTranslation(this.projectId, request).getData());
    }

    @Override
    public PreTranslationStatus startPreTranslationStringsBased(ApplyPreTranslationStringsBasedRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().applyPreTranslationStringsBased(this.projectId, request).getData());
    }

    @Override
    public PreTranslationStatus checkPreTranslation(String preTranslationId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().preTranslationStatus(this.projectId, preTranslationId).getData());
    }

    @Override
    public PreTranslationReportResponse getPreTranslationReport(String preTranslationId) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getTranslationsApi().getPreTranslationReport(this.projectId, preTranslationId).getData());
    }

    @Override
    public MachineTranslation getMt(Long mtId) throws ResponseException {
        LinkedHashMap<BiPredicate<String, String>, ResponseException> errorHandler = new LinkedHashMap<BiPredicate<String, String>, ResponseException>(){
            {
                this.put((code, message) -> code.equals("403") && message.contains("Endpoint isn't allowed for token scopes"), new ResponseException("Unable to retrieve MT due to insufficient token scopes"));
                this.put((code, message) -> code.equals("403"), new ResponseException("Unable to retrieve MT due to insufficient account or role permissions."));
            }
        };
        return (MachineTranslation)CrowdinProjectClient.executeRequest(errorHandler, () -> this.client.getMachineTranslationEnginesApi().getMt(mtId)).getData();
    }

    @Override
    public String getProjectUrl() {
        return this.getProject().getWebUrl();
    }

    @Override
    public List<? extends Project> listProjects() {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getProjectsGroupsApi().listProjects(null, 1, (Integer)limit, (Integer)offset));
    }

    @Override
    public Project addProject(AddProjectRequest request) {
        return CrowdinProjectClient.executeRequest(() -> this.client.getProjectsGroupsApi().addProject(request).getData());
    }

    @Override
    public List<ApplicationInstallation> listApplications() {
        return CrowdinProjectClient.executeRequestFullList((limit, offset) -> this.client.getApplicationsApi().listApplicationInstallations((Integer)limit, (Integer)offset));
    }

    @Override
    public void uninstallApplication(String id, boolean force) {
        CrowdinProjectClient.executeRequest(() -> this.client.getApplicationsApi().deleteApplicationInstallation(id, force));
    }

    @Override
    public void installApplication(String url) {
        InstallApplicationRequest req = new InstallApplicationRequest();
        req.setUrl(url);
        CrowdinProjectClient.executeRequest(() -> this.client.getApplicationsApi().installApplication(req));
    }

    @Override
    public Optional<String> findManifestUrl(String id) {
        String query = URLEncoder.encode("{\"slug\":{\"_eq\":\"" + id + "\"}}", StandardCharsets.UTF_8);
        URL url = new URL("https://developer.app.crowdin.net/items/Item?filter=" + query + "&fields=manifest");
        String res = new String(url.openStream().readAllBytes());
        JSONObject json = new JSONObject(res);
        JSONArray apps = (JSONArray)json.get("data");
        if (apps.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(((JSONObject)JSONObject.class.cast(apps.get(0))).get("manifest").toString());
    }

    @Override
    public User getAuthenticatedUser() {
        return CrowdinProjectClient.executeRequest(() -> this.client.getUsersApi().getAuthenticatedUser().getData());
    }
}

