/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class LanguageMapping {
    private final Map<String, Map<String, String>> languageMapping;

    protected LanguageMapping() {
        this.languageMapping = new HashMap<String, Map<String, String>>();
    }

    public boolean containsValue(String langCode, String placeholder) {
        return this.languageMapping.containsKey(langCode) && this.languageMapping.get(langCode).containsKey(placeholder);
    }

    public String getValue(String langCode, String placeholder) {
        if (!this.containsValue(langCode, placeholder)) {
            return null;
        }
        return this.languageMapping.get(langCode).get(placeholder);
    }

    public String getValueOrDefault(String langCode, String placeholder, String defaultValue) {
        String value = this.getValue(langCode, placeholder);
        return value != null ? value : defaultValue;
    }

    private LanguageMapping(Map<String, Map<String, String>> languageMapping) {
        this.languageMapping = languageMapping;
    }

    public static LanguageMapping fromServerLanguageMapping(Map<String, Map<String, String>> serverLanguageMapping) {
        return serverLanguageMapping == null ? new LanguageMapping() : new LanguageMapping(LanguageMapping.deepCopy(serverLanguageMapping));
    }

    public static LanguageMapping fromConfigFileLanguageMapping(Map<String, Map<String, String>> fileLanguageMapping) {
        return fileLanguageMapping == null ? new LanguageMapping() : new LanguageMapping(LanguageMapping.reverse(fileLanguageMapping));
    }

    public static LanguageMapping populate(@NonNull LanguageMapping from, @NonNull LanguageMapping to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        Map<String, Map<String, String>> sumLangMapping = LanguageMapping.deepCopy(to.languageMapping);
        for (Map.Entry<String, Map<String, String>> entry : from.languageMapping.entrySet()) {
            sumLangMapping.putIfAbsent(entry.getKey(), new HashMap());
            Map<String, String> sumLangMappingValues = sumLangMapping.get(entry.getKey());
            for (Map.Entry<String, String> entryValues : entry.getValue().entrySet()) {
                sumLangMappingValues.put(entryValues.getKey(), entryValues.getValue());
            }
        }
        return new LanguageMapping(sumLangMapping);
    }

    private static Map<String, Map<String, String>> deepCopy(Map<String, Map<String, String>> toCopy) {
        HashMap<String, Map<String, String>> copy = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : toCopy.entrySet()) {
            copy.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        return copy;
    }

    private static Map<String, Map<String, String>> reverse(Map<String, Map<String, String>> toReverse) {
        HashMap<String, Map<String, String>> languageMapping = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entryPlaceholder : toReverse.entrySet()) {
            for (Map.Entry<String, String> entryValues : entryPlaceholder.getValue().entrySet()) {
                languageMapping.putIfAbsent(entryValues.getKey(), new HashMap());
                ((Map)languageMapping.get(entryValues.getKey())).put(entryPlaceholder.getKey(), entryValues.getValue());
            }
        }
        return languageMapping;
    }

    public String toString() {
        return "LanguageMapping(languageMapping=" + String.valueOf(this.languageMapping) + ")";
    }
}

