/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.core.model.Priority;
import com.crowdin.client.sourcefiles.model.Branch;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class BranchAddAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String name;
    private final String title;
    private final String exportPattern;
    private final Priority priority;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        Map<String, Long> branches = client.listBranches().stream().collect(Collectors.toMap(Branch::getName, Branch::getId));
        if (!branches.containsKey(this.name)) {
            String branchName = BranchUtils.normalizeBranchName(this.name);
            String branchTitle = Objects.isNull(this.title) && !this.name.equals(branchName) ? this.name : this.title;
            Branch branch = client.addBranch(RequestBuilder.addBranch(branchName, branchTitle, this.exportPattern, this.priority));
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch.list"), branch.getId(), branch.getName())));
            } else {
                out.println(branch.getName());
            }
        } else {
            out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch_already_exists"), this.name)));
        }
    }

    public BranchAddAction(String name, String title, String exportPattern, Priority priority, boolean plainView) {
        this.name = name;
        this.title = title;
        this.exportPattern = exportPattern;
        this.priority = priority;
        this.plainView = plainView;
    }
}

