/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.core.model.PatchOperation;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.Priority;
import com.crowdin.client.sourcefiles.model.Branch;
import java.util.ArrayList;
import java.util.Optional;

class BranchEditAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String branch;
    private final String name;
    private final String title;
    private final Priority priority;
    private final boolean noProgress;
    private final boolean plainView;

    BranchEditAction(String branch, String name, String title, Priority priority, boolean noProgress, boolean plainView) {
        this.branch = branch;
        this.name = name;
        this.title = title;
        this.priority = priority;
        this.noProgress = noProgress;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        PatchRequest request;
        String normalizedSource;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadFullProject);
        Optional<Branch> branchObj = project.findBranchByName(normalizedSource = BranchUtils.normalizeBranchName(this.branch));
        if (branchObj.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.branch_not_exists"), this.branch));
        }
        ArrayList<PatchRequest> requests = new ArrayList<PatchRequest>();
        if (this.name != null) {
            String normalizedName = BranchUtils.normalizeBranchName(this.name);
            PatchRequest request2 = RequestBuilder.patch(normalizedName, PatchOperation.REPLACE, "/name");
            requests.add(request2);
        }
        if (this.title != null) {
            request = RequestBuilder.patch(this.title, PatchOperation.REPLACE, "/title");
            requests.add(request);
        }
        if (this.priority != null) {
            request = RequestBuilder.patch(this.priority, PatchOperation.REPLACE, "/priority");
            requests.add(request);
        }
        Branch updatedBranch = client.editBranch(branchObj.get().getId(), requests);
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch.list"), updatedBranch.getId(), updatedBranch.getName())));
        } else {
            out.println(updatedBranch.getName());
        }
    }
}

