/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.bundles.model.AddBundleRequest;
import com.crowdin.client.bundles.model.Bundle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class BundleCloneAction
implements NewAction<ProjectProperties, ClientBundle> {
    private Long id;
    private String name;
    private String format;
    private List<String> source;
    private List<String> ignore;
    private String translation;
    private List<Long> labels;
    private boolean plainView;
    private Boolean includeProjectSourceLanguage;
    private Boolean includePseudoLanguage;
    private Boolean isMultilingual;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientBundle client) {
        Bundle createdBundle;
        Bundle bundleToClone = client.getBundle(this.id);
        if (Objects.isNull(bundleToClone)) {
            out.println(ExecutionStatus.SKIPPED.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.not_found")));
            return;
        }
        AddBundleRequest addBundleRequest = new AddBundleRequest();
        addBundleRequest.setName((String)(Objects.isNull(this.name) ? bundleToClone.getName() + " (clone)" : this.name));
        addBundleRequest.setFormat(Optional.ofNullable(this.format).orElse(bundleToClone.getFormat()));
        addBundleRequest.setSourcePatterns(Optional.ofNullable(this.source).orElse(bundleToClone.getSourcePatterns()));
        addBundleRequest.setIgnorePatterns(Optional.ofNullable(this.ignore).orElse(bundleToClone.getIgnorePatterns()));
        addBundleRequest.setExportPattern(Optional.ofNullable(this.translation).orElse(bundleToClone.getExportPattern()));
        addBundleRequest.setIncludeProjectSourceLanguage(Optional.ofNullable(this.includeProjectSourceLanguage).orElse(bundleToClone.getIncludeProjectSourceLanguage()));
        addBundleRequest.setIncludeInContextPseudoLanguage(Optional.ofNullable(this.includePseudoLanguage).orElse(bundleToClone.getIncludeInContextPseudoLanguage()));
        addBundleRequest.setIsMultilingual(Optional.ofNullable(this.isMultilingual).orElse(bundleToClone.isMultilingual()));
        addBundleRequest.setLabelIds(this.labels != null ? this.labels : bundleToClone.getLabelIds());
        try {
            createdBundle = client.addBundle(addBundleRequest);
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.bundle_is_not_cloned"), addBundleRequest));
        }
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.list"), createdBundle.getId(), createdBundle.getFormat(), createdBundle.getExportPattern(), createdBundle.getName())));
        } else {
            out.println(String.valueOf(createdBundle.getId()));
        }
    }

    public BundleCloneAction(Long id, String name, String format, List<String> source, List<String> ignore, String translation, List<Long> labels, boolean plainView, Boolean includeProjectSourceLanguage, Boolean includePseudoLanguage, Boolean isMultilingual) {
        this.id = id;
        this.name = name;
        this.format = format;
        this.source = source;
        this.ignore = ignore;
        this.translation = translation;
        this.labels = labels;
        this.plainView = plainView;
        this.includeProjectSourceLanguage = includeProjectSourceLanguage;
        this.includePseudoLanguage = includePseudoLanguage;
        this.isMultilingual = isMultilingual;
    }
}

