/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.distributions.model.AddDistributionRequest;
import com.crowdin.client.distributions.model.AddDistributionStringsBasedRequest;
import com.crowdin.client.distributions.model.Distribution;
import com.crowdin.client.distributions.model.ExportMode;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class DistributionAddAction
implements NewAction<ProjectProperties, ClientDistribution> {
    private boolean noProgress;
    private boolean plainView;
    private String name;
    private ExportMode exportMode;
    private List<String> files;
    private List<Integer> bundleIds;
    private String branch;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientDistribution client) {
        Object addDistributionRequest;
        ProjectClient projectClient = GenericActCommand.getProjectClient(pb);
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> projectClient.downloadFullProject(this.branch));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (isStringsBasedProject && this.exportMode != null) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.strings_based_export_mode"));
        }
        List fileIds = null;
        if (this.files != null) {
            if (isStringsBasedProject) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
            }
            Map<String, Long> projectBranches = project.getBranches().values().stream().collect(Collectors.toMap(Branch::getName, Branch::getId));
            List<String> projectFiles = project.getFiles().stream().filter(file -> this.branch == null || file.getBranchId().equals(projectBranches.get(this.branch))).map(FileInfo::getPath).toList();
            List<String> notExistingFiles = this.files.stream().map(file -> this.branch == null ? file : Paths.get(this.branch, file).toString()).map(Utils::sepAtStart).map(Utils::toUnixPath).filter(file -> !projectFiles.contains(file)).toList();
            if (!notExistingFiles.isEmpty()) {
                throw new ExitCodeExceptionMapper.NotFoundException(notExistingFiles.stream().map(Utils::noSepAtStart).map(file -> String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_found"), file)).collect(Collectors.joining("\n\u274c ")));
            }
            this.files = this.branch != null ? this.files.stream().map(file -> Paths.get(this.branch, file).toString()).collect(Collectors.toList()) : this.files;
            this.files = this.files.stream().map(Utils::sepAtStart).map(Utils::toUnixPath).collect(Collectors.toList());
            fileIds = project.getFiles().stream().filter(file -> this.files.contains(file.getPath())).map(FileInfo::getId).collect(Collectors.toList());
        } else if (this.exportMode == ExportMode.DEFAULT && !isStringsBasedProject) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.empty_file"));
        }
        Distribution distribution = null;
        if (!isStringsBasedProject) {
            addDistributionRequest = RequestBuilder.addDistribution(this.name, this.exportMode, fileIds, this.bundleIds);
            Optional.ofNullable(this.name).ifPresent(((AddDistributionRequest)addDistributionRequest)::setName);
            Optional.ofNullable(this.exportMode).ifPresent(((AddDistributionRequest)addDistributionRequest)::setExportMode);
            Optional.ofNullable(fileIds).ifPresent(((AddDistributionRequest)addDistributionRequest)::setFileIds);
            Optional.ofNullable(this.bundleIds).ifPresent(((AddDistributionRequest)addDistributionRequest)::setBundleIds);
            try {
                distribution = client.addDistribution((AddDistributionRequest)addDistributionRequest);
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.distribution_is_not_added"), addDistributionRequest));
            }
        }
        if (isStringsBasedProject) {
            addDistributionRequest = new AddDistributionStringsBasedRequest();
            ((AddDistributionStringsBasedRequest)addDistributionRequest).setName(this.name);
            if (Objects.isNull(this.bundleIds)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.empty_bundle_ids"));
            }
            ((AddDistributionStringsBasedRequest)addDistributionRequest).setBundleIds(this.bundleIds);
            try {
                distribution = client.addDistributionStringsBased((AddDistributionStringsBasedRequest)addDistributionRequest);
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.distribution_is_not_added"), addDistributionRequest));
            }
        }
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.distribution.list"), distribution.getHash(), distribution.getName(), distribution.getExportMode())));
        } else {
            out.println(String.valueOf(distribution.getName()));
        }
    }

    public DistributionAddAction(boolean noProgress, boolean plainView, String name, ExportMode exportMode, List<String> files, List<Integer> bundleIds, String branch) {
        this.noProgress = noProgress;
        this.plainView = plainView;
        this.name = name;
        this.exportMode = exportMode;
        this.files = files;
        this.bundleIds = bundleIds;
        this.branch = branch;
    }
}

