/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.core.model.PatchOperation;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.distributions.model.Distribution;
import com.crowdin.client.distributions.model.ExportMode;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class DistributionEditAction
implements NewAction<ProjectProperties, ClientDistribution> {
    private String hash;
    private boolean noProgress;
    private boolean plainView;
    private String name;
    private ExportMode exportMode;
    private List<String> files;
    private List<Integer> bundleIds;
    private String branch;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientDistribution client) {
        PatchRequest request;
        PatchRequest request2;
        ProjectClient projectClient = GenericActCommand.getProjectClient(pb);
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> projectClient.downloadFullProject(this.branch));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        List<Distribution> distributions = client.listDistribution();
        Optional<Distribution> foundDistribution = distributions.stream().filter(d -> d.getHash().equals(this.hash)).findFirst();
        if (foundDistribution.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.not_found"), this.hash));
        }
        String existingExportMode = foundDistribution.get().getExportMode();
        ArrayList<PatchRequest> requests = new ArrayList<PatchRequest>();
        if (this.name != null) {
            request2 = RequestBuilder.patch(this.name, PatchOperation.REPLACE, "/name");
            requests.add(request2);
        }
        if (this.exportMode != null) {
            List<Integer> existingBundleIds = foundDistribution.get().getBundleIds();
            if (ExportMode.BUNDLE.equals(this.exportMode) && (existingBundleIds == null || existingBundleIds.isEmpty()) && this.bundleIds == null) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.empty_bundle_ids"));
            }
            if (isStringsBasedProject) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.strings_based_export_mode"));
            }
            request = RequestBuilder.patch(this.exportMode, PatchOperation.REPLACE, "/exportMode");
            requests.add(request);
        }
        if (this.files != null) {
            if (isStringsBasedProject) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
            }
            if (ExportMode.BUNDLE.equals(this.exportMode)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.incorrect_file_command_usage"));
            }
            if (ExportMode.BUNDLE.name().equals(existingExportMode) && !ExportMode.DEFAULT.equals(this.exportMode)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.incorrect_file_command_usage"));
            }
            List<Long> fileIds = this.prepareFileIds(project);
            if (!fileIds.isEmpty()) {
                request = RequestBuilder.patch(fileIds, PatchOperation.REPLACE, "/fileIds");
                requests.add(request);
            }
        }
        if (this.bundleIds != null) {
            if (ExportMode.DEFAULT.equals(this.exportMode)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.incorrect_bundle_id_command_usage"));
            }
            if (ExportMode.DEFAULT.name().equals(existingExportMode) && !ExportMode.BUNDLE.equals(this.exportMode)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.distribution.incorrect_bundle_id_command_usage"));
            }
            request2 = RequestBuilder.patch(this.bundleIds, PatchOperation.REPLACE, "/bundleIds");
            requests.add(request2);
        }
        Distribution updatedDistribution = client.editDistribution(this.hash, requests);
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.distribution.list"), updatedDistribution.getHash(), updatedDistribution.getName(), updatedDistribution.getExportMode())));
        } else {
            out.println(updatedDistribution.getName());
        }
    }

    private List<Long> prepareFileIds(CrowdinProjectFull project) {
        List<String> projectFiles = project.getFiles().stream().map(FileInfo::getPath).toList();
        List<String> notExistingFiles = this.files.stream().map(file -> this.branch == null ? file : Paths.get(this.branch, file).toString()).map(Utils::sepAtStart).map(Utils::toUnixPath).filter(file -> !projectFiles.contains(file)).toList();
        if (!notExistingFiles.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(notExistingFiles.stream().map(Utils::noSepAtStart).map(file -> String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_found"), file)).collect(Collectors.joining("\n\u274c ")));
        }
        this.files = this.branch != null ? this.files.stream().map(file -> Paths.get(this.branch, file).toString()).collect(Collectors.toList()) : this.files;
        this.files = this.files.stream().map(Utils::sepAtStart).map(Utils::toUnixPath).collect(Collectors.toList());
        return project.getFiles().stream().filter(file -> this.files.contains(file.getPath())).map(FileInfo::getId).collect(Collectors.toList());
    }

    public DistributionEditAction(String hash, boolean noProgress, boolean plainView, String name, ExportMode exportMode, List<String> files, List<Integer> bundleIds, String branch) {
        this.hash = hash;
        this.noProgress = noProgress;
        this.plainView = plainView;
        this.name = name;
        this.exportMode = exportMode;
        this.files = files;
        this.bundleIds = bundleIds;
        this.branch = branch;
    }
}

