/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.distributions.model.Distribution;
import java.util.List;

class DistributionListAction
implements NewAction<ProjectProperties, ClientDistribution> {
    private final boolean plainView;

    public DistributionListAction(boolean plainView) {
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientDistribution client) {
        List<Distribution> distributions = client.listDistribution();
        for (Distribution distribution : distributions) {
            if (!this.plainView) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.distribution.list"), distribution.getHash(), distribution.getName(), distribution.getExportMode()));
                continue;
            }
            out.println(String.format("%s %s", distribution.getHash(), distribution.getName()));
        }
        if (distributions.isEmpty()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.distribution.list_empty")));
            } else {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.distribution.list_empty"));
            }
        }
    }
}

