/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.client.MaxNumberOfRetriesException;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.FilesInterface;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.functionality.TranslationsUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.properties.PseudoLocalization;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.translations.model.BuildProjectTranslationRequest;
import com.crowdin.client.translations.model.CrowdinTranslationCraeteProjectPseudoBuildForm;
import com.crowdin.client.translations.model.CrowdinTranslationCreateProjectBuildForm;
import com.crowdin.client.translations.model.ProjectBuild;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

class DownloadAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private FilesInterface files;
    private boolean noProgress;
    private List<String> languageIds;
    private List<String> excludeLanguageIds;
    private boolean pseudo;
    private String branchName;
    private boolean ignoreMatch;
    private boolean isVerbose;
    private boolean plainView;
    private boolean useServerSources;
    private boolean keepArchive;
    private Outputter out;

    public DownloadAction(FilesInterface files, boolean noProgress, List<String> languageIds, List<String> excludeLanguageIds, boolean pseudo, String branchName, boolean ignoreMatch, boolean isVerbose, boolean plainView, boolean useServerSources, boolean keepArchive) {
        this.files = files;
        this.noProgress = noProgress || plainView;
        this.languageIds = languageIds;
        this.excludeLanguageIds = excludeLanguageIds;
        this.pseudo = pseudo;
        this.branchName = branchName;
        this.ignoreMatch = ignoreMatch;
        this.isVerbose = isVerbose;
        this.plainView = plainView;
        this.useServerSources = useServerSources;
        this.keepArchive = keepArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void act(Outputter out, PropertiesWithFiles pb, ProjectClient client) {
        block36: {
            this.out = out;
            boolean isOrganization = PropertiesBeanUtils.isOrganization(pb.getBaseUrl());
            CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
            if (Objects.equals(project.getType(), Type.STRINGS_BASED)) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
            }
            if (!project.isManagerAccess()) {
                if (!this.plainView) {
                    out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                    return;
                }
                throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
            }
            if (this.useServerSources && !pb.getPreserveHierarchy().booleanValue() && !this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.download_translations.preserve_hierarchy_warning")));
            }
            PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(true), pb.getBasePath());
            List languages = this.languageIds == null ? null : this.languageIds.stream().map(lang -> project.findLanguageById((String)lang, true).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), lang)))).collect(Collectors.toList());
            ArrayList excludeLanguages = this.excludeLanguageIds == null ? new ArrayList() : this.excludeLanguageIds.stream().map(lang -> project.findLanguageById((String)lang, true).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), lang)))).collect(Collectors.toList());
            Optional<Branch> branch = Optional.ofNullable(project.getBranch());
            Map<String, com.crowdin.client.sourcefiles.model.File> serverSources = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getFiles());
            LanguageMapping serverLanguageMapping = project.getLanguageMapping();
            AtomicBoolean skipUntranslatedFiles = new AtomicBoolean(false);
            TreeMap fileBeansWithDownloadedFiles = new TreeMap();
            HashMap<File, List<String>> tempDirs = new HashMap<File, List<String>>();
            try {
                if (this.pseudo) {
                    forLanguages = project.getSupportedLanguages();
                    if (!this.plainView) {
                        out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.build_archive_pseudo")));
                    }
                    PseudoLocalization pl = pb.getPseudoLocalization();
                    CrowdinTranslationCraeteProjectPseudoBuildForm request = this.branchName != null ? (pl != null ? RequestBuilder.crowdinTranslationCreateProjectPseudoBuildForm(branch.get().getId(), true, pl.getLengthCorrection(), pl.getPrefix(), pl.getSuffix(), pl.getCharTransformation()) : RequestBuilder.crowdinTranslationCreateProjectPseudoBuildForm(1L, true, null, null, null, null)) : (pl != null ? RequestBuilder.crowdinTranslationCreateProjectPseudoBuildForm(true, pl.getLengthCorrection(), pl.getPrefix(), pl.getSuffix(), pl.getCharTransformation()) : RequestBuilder.crowdinTranslationCreateProjectPseudoBuildForm(true, null, null, null, null));
                    Pair<File, List<String>> downloadedFiles = this.download(request, client, pb.getBasePath(), this.keepArchive);
                    for (FileBean fb2 : pb.getFiles()) {
                        Map<String, String> filesWithMapping = this.getFiles(fb2, pb.getBasePath(), serverLanguageMapping, forLanguages, placeholderUtil, new ArrayList<String>(serverSources.keySet()), pb.getPreserveHierarchy());
                        fileBeansWithDownloadedFiles.putIfAbsent(downloadedFiles.getLeft(), new ArrayList());
                        ((List)fileBeansWithDownloadedFiles.get(downloadedFiles.getLeft())).add(filesWithMapping);
                    }
                    tempDirs.put(downloadedFiles.getLeft(), downloadedFiles.getRight());
                } else {
                    List<Object> list = forLanguages = languages != null ? languages : project.getProjectLanguages(true).stream().filter(language -> !excludeLanguages.contains(language)).collect(Collectors.toList());
                    if (!this.plainView) {
                        out.println(this.languageIds != null ? ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.build_language_archive"), String.join((CharSequence)", ", this.languageIds))) : ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.build_archive")));
                    }
                    CrowdinTranslationCreateProjectBuildForm templateRequest = new CrowdinTranslationCreateProjectBuildForm();
                    if (languages != null) {
                        templateRequest.setTargetLanguageIds(languages.stream().map(Language::getId).collect(Collectors.toList()));
                    } else if (!excludeLanguages.isEmpty()) {
                        templateRequest.setTargetLanguageIds(forLanguages.stream().map(Language::getId).collect(Collectors.toList()));
                    }
                    branch.map(Branch::getId).ifPresent(templateRequest::setBranchId);
                    pb.getFiles().stream().map(fb -> Pair.of(Pair.of(fb.getSkipTranslatedOnly(), fb.getSkipUntranslatedFiles()), Pair.of(fb.getExportApprovedOnly(), fb.getExportStringsThatPassedWorkflow()))).distinct().forEach(downloadConfiguration -> {
                        CrowdinTranslationCreateProjectBuildForm buildRequest = RequestBuilder.crowdinTranslationCreateProjectBuildForm(templateRequest);
                        buildRequest.setSkipUntranslatedStrings((Boolean)((Pair)downloadConfiguration.getLeft()).getLeft());
                        buildRequest.setSkipUntranslatedFiles((Boolean)((Pair)downloadConfiguration.getLeft()).getRight());
                        if (buildRequest.getSkipUntranslatedFiles() != null && buildRequest.getSkipUntranslatedFiles().booleanValue()) {
                            skipUntranslatedFiles.set(buildRequest.getSkipUntranslatedFiles());
                        }
                        if (isOrganization) {
                            if (((Pair)downloadConfiguration.getRight()).getLeft() != null && ((Boolean)((Pair)downloadConfiguration.getRight()).getLeft()).booleanValue()) {
                                buildRequest.setExportWithMinApprovalsCount(1);
                            }
                            if (((Pair)downloadConfiguration.getRight()).getRight() != null && ((Boolean)((Pair)downloadConfiguration.getRight()).getRight()).booleanValue()) {
                                buildRequest.setExportStringsThatPassedWorkflow(true);
                            }
                        } else {
                            buildRequest.setExportApprovedOnly((Boolean)((Pair)downloadConfiguration.getRight()).getLeft());
                            if (((Pair)downloadConfiguration.getRight()).getRight() != null && ((Boolean)((Pair)downloadConfiguration.getRight()).getRight()).booleanValue()) {
                                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.export_strings_that_passed_workflow_not_supported")));
                            }
                        }
                        Pair<File, List<String>> downloadedFiles = this.download(buildRequest, client, pb.getBasePath(), this.keepArchive);
                        for (FileBean fb : pb.getFiles()) {
                            if (fb.getSkipTranslatedOnly() != ((Pair)downloadConfiguration.getLeft()).getLeft() || fb.getSkipUntranslatedFiles() != ((Pair)downloadConfiguration.getLeft()).getRight() || fb.getExportApprovedOnly() != ((Pair)downloadConfiguration.getRight()).getLeft() || fb.getExportStringsThatPassedWorkflow() != ((Pair)downloadConfiguration.getRight()).getRight()) continue;
                            Map<String, String> filesWithMapping = this.getFiles(fb, pb.getBasePath(), serverLanguageMapping, forLanguages, placeholderUtil, new ArrayList<String>(serverSources.keySet()), pb.getPreserveHierarchy());
                            fileBeansWithDownloadedFiles.putIfAbsent(downloadedFiles.getLeft(), new ArrayList());
                            ((List)fileBeansWithDownloadedFiles.get(downloadedFiles.getLeft())).add(filesWithMapping);
                        }
                        tempDirs.put(downloadedFiles.getLeft(), downloadedFiles.getRight());
                    });
                }
                TreeMap<File, Set<Pair<String, String>>> fileBeansWithDownloadedFilesNoRepetitions = new TreeMap<File, Set<Pair<String, String>>>();
                for (File tempDir : fileBeansWithDownloadedFiles.keySet()) {
                    fileBeansWithDownloadedFilesNoRepetitions.put(tempDir, this.flattenInnerMap((Collection)fileBeansWithDownloadedFiles.get(tempDir)));
                }
                Map<Long, String> directoryPaths = branch.isPresent() ? ProjectFilesUtils.buildDirectoryPaths(project.getDirectories()) : ProjectFilesUtils.buildDirectoryPaths(project.getDirectories(), project.getBranches());
                Map<String, List<String>> allProjectTranslations = ProjectFilesUtils.buildAllProjectTranslations(project.getFiles(), directoryPaths, branch.map(Branch::getId), placeholderUtil, serverLanguageMapping, pb.getBasePath());
                Map<String, List> totalOmittedFiles = null;
                ArrayList<List<String>> omittedFilesNoSources = new ArrayList<List<String>>();
                AtomicBoolean anyFileDownloaded = new AtomicBoolean(false);
                for (File tempDir : fileBeansWithDownloadedFilesNoRepetitions.keySet()) {
                    Set set = (Set)fileBeansWithDownloadedFilesNoRepetitions.get(tempDir);
                    List downloadedFiles = (List)tempDirs.get(tempDir);
                    Pair<Map<File, File>, List<String>> result = this.sortFiles(downloadedFiles, set, pb.getBasePath(), tempDir.getAbsolutePath() + Utils.PATH_SEPARATOR);
                    new TreeMap<File, File>(result.getLeft()).forEach((fromFile, toFile) -> {
                        this.files.copyFile((File)fromFile, (File)toFile);
                        anyFileDownloaded.set(true);
                        if (!this.plainView) {
                            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file_path"), StringUtils.removeStart(toFile.getAbsolutePath(), pb.getBasePath()))));
                        } else {
                            out.println(StringUtils.removeStart(toFile.getAbsolutePath(), pb.getBasePath()));
                        }
                    });
                    Pair<Map<String, List<String>>, List<String>> omittedFiles = this.sortOmittedFiles(result.getRight(), allProjectTranslations);
                    TreeMap<String, List<String>> allOmittedFiles = new TreeMap<String, List<String>>(omittedFiles.getLeft());
                    List<String> allOmittedFilesNoSources = omittedFiles.getRight();
                    if (totalOmittedFiles == null) {
                        totalOmittedFiles = new TreeMap<String, List>();
                        for (String sourceKey : allOmittedFiles.keySet()) {
                            totalOmittedFiles.put(sourceKey, (List)allOmittedFiles.get(sourceKey));
                        }
                    } else {
                        for (String sourceKey : allOmittedFiles.keySet()) {
                            if (!totalOmittedFiles.containsKey(sourceKey)) continue;
                            totalOmittedFiles.get(sourceKey).retainAll((Collection)allOmittedFiles.get(sourceKey));
                        }
                        for (String sourceKey : totalOmittedFiles.keySet()) {
                            if (allOmittedFiles.containsKey(sourceKey)) continue;
                            totalOmittedFiles.put(sourceKey, new ArrayList());
                        }
                    }
                    omittedFilesNoSources.add(allOmittedFilesNoSources);
                }
                if (!this.ignoreMatch && !this.plainView) {
                    if (!(totalOmittedFiles = totalOmittedFiles.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                        out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.downloaded_files_omitted")));
                        totalOmittedFiles.forEach((file, translations) -> {
                            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.item_list_with_count"), file, translations.size()));
                            if (this.isVerbose) {
                                translations.forEach(trans -> out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.inner_item_list"), trans)));
                            }
                        });
                        out.println(ExecutionStatus.EMPTY.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.faq_link")));
                    }
                    List totalOmittedFilesNoSources = omittedFilesNoSources.isEmpty() ? new ArrayList() : (List)omittedFilesNoSources.get(0);
                    for (List list : omittedFilesNoSources) {
                        totalOmittedFilesNoSources.retainAll(list);
                    }
                    if (!totalOmittedFilesNoSources.isEmpty()) {
                        out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.downloaded_files_omitted_without_sources")));
                        totalOmittedFilesNoSources.forEach(file -> out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.item_list"), file)));
                        out.println(ExecutionStatus.EMPTY.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.faq_link")));
                    }
                }
                if (anyFileDownloaded.get()) break block36;
                if (project.getSkipUntranslatedFiles() || skipUntranslatedFiles.get()) {
                    out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.warning.no_file_to_download_skipuntranslated")));
                    break block36;
                }
                throw new ExitCodeExceptionMapper.ValidationException(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.warning.no_file_to_download")));
            }
            catch (ProjectBuildFailedException e) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.translations_build_unsuccessful")));
            }
            finally {
                try {
                    for (File tempDir : tempDirs.keySet()) {
                        this.files.deleteDirectory(tempDir);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.clearing_temp"), e);
                }
            }
        }
    }

    private Pair<File, List<String>> download(BuildProjectTranslationRequest request, ProjectClient client, String basePath, Boolean keepArchive) {
        ProjectBuild projectBuild = this.buildTranslation(client, request);
        if (projectBuild == null) {
            throw new ProjectBuildFailedException();
        }
        String randomHash = RandomStringUtils.random(11, false, true);
        File baseTempDir = new File(StringUtils.removeEnd(basePath, Utils.PATH_SEPARATOR) + Utils.PATH_SEPARATOR + "CrowdinTranslations_" + randomHash + Utils.PATH_SEPARATOR);
        String downloadedZipArchivePath = StringUtils.removeEnd(basePath, Utils.PATH_SEPARATOR) + Utils.PATH_SEPARATOR + "CrowdinTranslations_" + randomHash + ".zip";
        File downloadedZipArchive = new File(downloadedZipArchivePath);
        this.downloadTranslations(client, projectBuild.getId(), downloadedZipArchivePath);
        List downloadedFilesProc = this.extractArchive(downloadedZipArchive, baseTempDir).stream().map(f -> StringUtils.removeStart(f.getAbsolutePath(), baseTempDir.getAbsolutePath() + Utils.PATH_SEPARATOR)).collect(Collectors.toList());
        if (!keepArchive.booleanValue()) {
            try {
                this.files.deleteFile(downloadedZipArchive);
            }
            catch (IOException e) {
                this.out.println(ExecutionStatus.ERROR.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.deleting_archive"), downloadedZipArchive)));
            }
        } else if (!this.plainView) {
            this.out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.archive"), downloadedZipArchivePath)));
        } else {
            this.out.println(downloadedZipArchivePath);
        }
        return Pair.of(baseTempDir, downloadedFilesProc);
    }

    private Map<String, String> getFiles(FileBean fb, String basePath, LanguageMapping serverLanguageMapping, List<Language> forLanguages, PlaceholderUtil placeholderUtil, List<String> allServerSources, boolean preserveHierarchy) {
        List<String> sources = SourcesUtils.getFiles(basePath, fb.getSource(), fb.getIgnore(), placeholderUtil).map(File::getAbsolutePath).collect(Collectors.toList());
        if (this.useServerSources) {
            String searchPattern = fb.getDest() != null ? fb.getDest() : fb.getSource();
            List serverSources = SourcesUtils.filterProjectFiles(allServerSources, searchPattern, fb.getIgnore(), preserveHierarchy, placeholderUtil).stream().map(s -> Utils.joinPaths(basePath, s)).filter(s -> !sources.contains(s)).collect(Collectors.toList());
            sources.addAll(serverSources);
        }
        LanguageMapping localLanguageMapping = LanguageMapping.fromConfigFileLanguageMapping(fb.getLanguagesMapping());
        LanguageMapping languageMapping = LanguageMapping.populate(localLanguageMapping, serverLanguageMapping);
        HashMap<String, String> translationReplace = fb.getTranslationReplace() != null ? fb.getTranslationReplace() : new HashMap<String, String>();
        return this.doTranslationMapping(forLanguages, fb.getDest(), fb.getTranslation(), serverLanguageMapping, languageMapping, translationReplace, sources, fb.getSource(), basePath, placeholderUtil, preserveHierarchy);
    }

    private ProjectBuild buildTranslation(ProjectClient client, BuildProjectTranslationRequest request) {
        AtomicInteger sleepTime = new AtomicInteger(BaseCli.CHECK_WAITING_TIME_FIRST);
        return ConsoleSpinner.execute(this.out, "message.spinner.building_translations", "error.building_translation", this.noProgress, this.plainView, () -> {
            ProjectBuild build = null;
            try {
                build = client.startBuildingTranslation(request);
                while (!build.getStatus().equalsIgnoreCase("finished")) {
                    ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.building_translation"), Math.toIntExact(build.getProgress().intValue())));
                    Thread.sleep(sleepTime.getAndUpdate(val -> val < BaseCli.CHECK_WAITING_TIME_MAX ? val + BaseCli.CHECK_WAITING_TIME_INCREMENT : BaseCli.CHECK_WAITING_TIME_MAX));
                    if (!(build = client.checkBuildingTranslation(build.getId())).getStatus().equalsIgnoreCase("failed")) continue;
                    throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.build_has_failed"));
                }
                ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.building_translation"), 100));
            }
            catch (MaxNumberOfRetriesException e) {
                ConsoleSpinner.stop(ExecutionStatus.ERROR);
                throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.warning.maximum_retries_exceeded"), 3));
            }
            return build;
        });
    }

    private Pair<Map<File, File>, List<String>> sortFiles(List<String> downloadedFiles, Set<Pair<String, String>> filesWithMapping, String basePath, String baseTempDir) {
        HashSet<String> downloadedFilesSet = new HashSet<String>(downloadedFiles);
        Map<File, File> fileMapping = filesWithMapping.stream().filter(pair -> downloadedFilesSet.contains(pair.getLeft())).collect(Collectors.toMap(pair -> new File(Utils.joinPaths(baseTempDir, (String)pair.getLeft())), pair -> new File(Utils.joinPaths(basePath, (String)pair.getRight()))));
        Set filesWithMappingFrom = filesWithMapping.stream().map(Pair::getLeft).collect(Collectors.toSet());
        List omittedFiles = downloadedFiles.stream().filter(downloadedFile -> !filesWithMappingFrom.contains(downloadedFile)).collect(Collectors.toList());
        return new ImmutablePair<Map<File, File>, List<String>>(fileMapping, omittedFiles);
    }

    private Pair<Map<String, List<String>>, List<String>> sortOmittedFiles(List<String> omittedFiles, Map<String, List<String>> allProjectTranslations) {
        HashMap allOmittedFiles = new HashMap();
        ArrayList<String> allOmittedFilesNoSources = new ArrayList<String>();
        for (String omittedFile : omittedFiles) {
            boolean isFound = false;
            for (Map.Entry<String, List<String>> entry : allProjectTranslations.entrySet()) {
                if (!entry.getValue().contains(omittedFile)) continue;
                isFound = true;
                allOmittedFiles.putIfAbsent(entry.getKey(), new ArrayList());
                ((List)allOmittedFiles.get(entry.getKey())).add(StringUtils.removeStart(omittedFile, Utils.PATH_SEPARATOR));
            }
            if (isFound) continue;
            allOmittedFilesNoSources.add(StringUtils.removeStart(omittedFile, Utils.PATH_SEPARATOR));
        }
        return new ImmutablePair<Map<String, List<String>>, List<String>>(allOmittedFiles, allOmittedFilesNoSources);
    }

    private Map<String, String> doTranslationMapping(List<Language> languages, String dest, String translation, LanguageMapping projLanguageMapping, LanguageMapping languageMapping, Map<String, String> translationReplace, List<String> sources, String source, String basePath, PlaceholderUtil placeholderUtil, boolean preserveHierarchy) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Language language : languages) {
            translation = Utils.sepAtStart(translation);
            String translationProject1 = placeholderUtil.replaceLanguageDependentPlaceholders(translation, projLanguageMapping, language);
            String translationFile1 = placeholderUtil.replaceLanguageDependentPlaceholders(translation, languageMapping, language);
            if (!preserveHierarchy) {
                translationProject1 = StringUtils.remove(translationProject1, "%original_path%");
            }
            for (String projectFile : sources) {
                String file = StringUtils.removeStart(projectFile, basePath);
                String translationProject2 = TranslationsUtils.replaceDoubleAsterisk(source, translationProject1, file);
                String translationFile2 = TranslationsUtils.replaceDoubleAsterisk(source, translationFile1, file);
                translationProject2 = dest != null && !PlaceholderUtil.containsLangPlaceholders(translation) ? placeholderUtil.replaceFileDependentPlaceholders(dest, new File(PropertiesBeanUtils.prepareDest(dest, file, placeholderUtil))) : (dest == null ? placeholderUtil.replaceFileDependentPlaceholders(translationProject2, new File(projectFile)) : placeholderUtil.replaceFileDependentPlaceholders(translationProject2, new File(PropertiesBeanUtils.prepareDest(dest, file, placeholderUtil))));
                translationFile2 = placeholderUtil.replaceFileDependentPlaceholders(translationFile2, new File(projectFile));
                translationFile2 = PropertiesBeanUtils.useTranslationReplace(translationFile2, translationReplace);
                mapping.put(translationProject2, translationFile2);
            }
        }
        return mapping;
    }

    private void downloadTranslations(ProjectClient client, Long buildId, String archivePath) {
        ConsoleSpinner.execute(this.out, "message.spinner.downloading_translations", "error.downloading_file", this.noProgress, this.plainView, () -> {
            URL url = client.downloadBuild(buildId);
            try (InputStream data = url.openStream();){
                this.files.writeToFile(archivePath, data);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), archivePath), e);
            }
            return url;
        });
    }

    private List<File> extractArchive(File zipArchive, File dir) {
        return ConsoleSpinner.execute(this.out, "message.spinner.extracting_archive", "error.extracting_files", this.noProgress, this.plainView, () -> this.files.extractZipArchive(zipArchive, dir));
    }

    private Set<Pair<String, String>> flattenInnerMap(Collection<Map<String, String>> toFlatten) {
        TreeSet<Pair<String, String>> result = new TreeSet<Pair<String, String>>();
        for (Map<String, String> map : toFlatten) {
            for (String key : map.keySet()) {
                result.add(Pair.of(key, map.get(key)));
            }
        }
        return result;
    }

    private static class ProjectBuildFailedException
    extends RuntimeException {
        private ProjectBuildFailedException() {
        }
    }
}

